/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import com.oceanbase.tools.loaddump.metrics.Clock;
import com.oceanbase.tools.loaddump.metrics.ExponentialMovingAverages;
import com.oceanbase.tools.loaddump.metrics.Metered;
import com.oceanbase.tools.loaddump.metrics.MovingAverages;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.collections.MapUtils;

public class Meter
implements Metered {
    private static final long ONE_NANOS = 1000000000L;
    private final MovingAverages movingAverages;
    private final LongAdder tps = new LongAdder();
    private final Map<String, AtomicLong> bufferMap = new ConcurrentHashMap<String, AtomicLong>();
    private final LongAdder throughput = new LongAdder();
    private final long startTime;
    private final Clock clock;

    public Meter(MovingAverages movingAverages) {
        this(movingAverages, Clock.defaultClock());
    }

    public Meter() {
        this(Clock.defaultClock());
    }

    public Meter(Clock clock) {
        this(new ExponentialMovingAverages(clock), clock);
    }

    public Meter(MovingAverages movingAverages, Clock clock) {
        this.movingAverages = movingAverages;
        this.clock = clock;
        this.startTime = this.clock.getTick();
    }

    public void mark(long n, long bytes, long slots) {
        this.mark("0.0.0.0", n, bytes, slots);
    }

    public void mark(String leader, long count, long bytes, long slots) {
        this.movingAverages.tickIfNecessary();
        this.tps.add(count);
        this.throughput.add(bytes);
        this.movingAverages.updateTps(count);
        this.movingAverages.updateThroughput(bytes);
        AtomicLong buffer = this.bufferMap.getOrDefault(leader, new AtomicLong());
        buffer.set(slots);
        this.bufferMap.putIfAbsent(leader, buffer);
    }

    @Override
    public long getTps() {
        return this.tps.sum();
    }

    @Override
    public long getThroughput() {
        return this.throughput.sum();
    }

    @Override
    public String[] getBuffer() {
        if (MapUtils.isEmpty(this.bufferMap)) {
            return new String[]{"1 Slots"};
        }
        int index = 0;
        StringBuilder sb = new StringBuilder(256);
        String[] buffer = new String[this.bufferMap.size()];
        for (Map.Entry<String, AtomicLong> entry : this.bufferMap.entrySet()) {
            String host = entry.getKey();
            if (JvmArgs.isDebugable && host != null && this.bufferMap.size() > 1) {
                if (host.contains(".")) {
                    host = "*.*.*." + host.split("[\\.]")[3];
                }
                sb.append("[").append(host).append("] ");
            }
            sb.append(entry.getValue()).append(" Slots");
            buffer[index++] = sb.toString();
            sb.setLength(0);
        }
        return buffer;
    }

    @Override
    public double getMeanTpsRate() {
        double tps = this.getTps();
        if (tps == 0.0) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return tps / elapsed * 1.0E9;
    }

    @Override
    public double getMeanThroughputRate() {
        double throughput = this.getThroughput();
        if (throughput == 0.0) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return throughput / elapsed * 1.0E9;
    }

    @Override
    public double getOneMinuteTpsRate() {
        this.movingAverages.tickIfNecessary();
        return this.movingAverages.getTpsM1Rate();
    }

    @Override
    public double getOneMinuteThroughputRate() {
        this.movingAverages.tickIfNecessary();
        return this.movingAverages.getThroughputM1Rate();
    }
}

