/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.Metric;
import com.oceanbase.tools.loaddump.metrics.MetricRegistryListener;
import com.oceanbase.tools.loaddump.metrics.MetricSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetricRegistry
implements MetricSet {
    private final ConcurrentMap<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    private final List<MetricRegistryListener> listeners = new CopyOnWriteArrayList<MetricRegistryListener>();

    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricRegistry.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricRegistry.append(builder, s);
            }
        }
        return builder.toString();
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistry.name(klass.getName(), names);
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        if (metric instanceof MetricRegistry) {
            final String childName = name;
            MetricRegistry childRegistry = (MetricRegistry)metric;
            childRegistry.addListener(new MetricRegistryListener(){

                @Override
                public void onMeterAdded(String name, Meter meter) {
                    MetricRegistry.this.register(MetricRegistry.name(childName, name), meter);
                }
            });
        } else if (metric instanceof MetricSet) {
            this.registerAll(name, (MetricSet)metric);
        } else {
            Metric existing = this.metrics.putIfAbsent(name, metric);
            if (existing == null) {
                this.onMetricAdded(name, metric);
            } else {
                throw new IllegalArgumentException("A metric named " + name + " already exists");
            }
        }
        return metric;
    }

    public void registerAll(MetricSet metrics) throws IllegalArgumentException {
        this.registerAll(null, metrics);
    }

    public void registerAll(String prefix, MetricSet metrics) throws IllegalArgumentException {
        for (Map.Entry<String, Metric> entry : metrics.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(MetricRegistry.name(prefix, entry.getKey()), (MetricSet)entry.getValue());
                continue;
            }
            this.register(MetricRegistry.name(prefix, entry.getKey()), entry.getValue());
        }
    }

    public Meter meter(String name) {
        return this.getOrAdd(name, MetricBuilder.METERS);
    }

    public Meter meter(String name, final MetricSupplier<Meter> supplier) {
        return this.getOrAdd(name, new MetricBuilder<Meter>(){

            @Override
            public Meter newMetric() {
                return (Meter)supplier.newMetric();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }
        });
    }

    public void addListener(MetricRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.metrics.entrySet()) {
            this.notifyListenerOfAddedMetric(listener, (Metric)entry.getValue(), (String)entry.getKey());
        }
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMetrics(Meter.class);
    }

    private <T extends Metric> T getOrAdd(String name, MetricBuilder<T> builder) {
        block4: {
            Metric metric = (Metric)this.metrics.get(name);
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return this.register(name, builder.newMetric());
                }
                catch (IllegalArgumentException e) {
                    Metric added = (Metric)this.metrics.get(name);
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private <T extends Metric> SortedMap<String, T> getMetrics(Class<T> klass) {
        TreeMap timers = new TreeMap();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!klass.isInstance(entry.getValue())) continue;
            timers.put(entry.getKey(), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(timers);
    }

    private void onMetricAdded(String name, Metric metric) {
        for (MetricRegistryListener listener : this.listeners) {
            this.notifyListenerOfAddedMetric(listener, metric, name);
        }
    }

    private void notifyListenerOfAddedMetric(MetricRegistryListener listener, Metric metric, String name) {
        if (!(metric instanceof Meter)) {
            throw new IllegalArgumentException("Unknown metric type: " + metric.getClass());
        }
        listener.onMeterAdded(name, (Meter)metric);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    private static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){

            @Override
            public Meter newMetric() {
                return new Meter();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }
        };

        public T newMetric();

        public boolean isInstance(Metric var1);
    }

    @FunctionalInterface
    public static interface MetricSupplier<T extends Metric> {
        public T newMetric();
    }
}

