/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import com.oceanbase.tools.loaddump.metrics.AbstractScheduledReporter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.MetricAttribute;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jReporter
extends AbstractScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(Slf4jReporter.class);

    private Slf4jReporter(MetricRegistry registry, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, "slf4j-reporter", rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    @Override
    public void report(SortedMap<String, Meter> meters) {
        if (MapUtils.isNotEmpty(meters)) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Meter> entry : meters.entrySet()) {
                this.logMeter(b, entry.getKey(), entry.getValue());
            }
            this.outputTo(b.append("\n\n").toString());
        }
    }

    @Override
    protected void outputTo(String string) {
        log.info(string);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.disabledMetricAttributes = Collections.emptySet();
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public Slf4jReporter build() {
            return new Slf4jReporter(this.registry, this.rateUnit, this.durationUnit, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }
    }
}

