/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type;

import com.oceanbase.tools.loaddump.common.exception.UnexpectedResultException;
import com.oceanbase.tools.loaddump.mybatis.type.AbstractTypeReference;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseTypeHandler<T>
extends AbstractTypeReference<T>
implements TypeHandler<T> {
    private static final long serialVersionUID = 7919033420401328376L;

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        Object result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            String columnName = rs.getMetaData().getColumnName(columnIndex);
            String className = this.getClass().getSimpleName();
            throw new UnexpectedResultException("Result is null but [{}:{}] was defined as NOT NULL. Class: {}", columnIndex, columnName, className);
        }
        return result;
    }

    private T resolveMySqlZeroDateTimeValue(ResultSet rs, T result, int columnIndex) throws SQLException {
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            String columnName = rs.getMetaData().getColumnName(columnIndex);
            String className = this.getClass().getSimpleName();
            throw new UnexpectedResultException("Result is null but [{}:{}] was defined as NOT NULL. Class: {}", columnIndex, columnName, className);
        }
        return result;
    }
}

