/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.cut;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutRecordParserV2
extends AbstractRowOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(CutRecordParserV2.class);
    private static final String DEFAULT_LINE_SEPARATOR = System.lineSeparator();
    private static final boolean IS_NEWLINE_ON_WINDOWS = DEFAULT_LINE_SEPARATOR.equals("\r\n");
    private AtomicInteger fieldCount = new AtomicInteger(0);
    private final BufferedReader reader;
    private final String nullString;
    private final String columnSplitter;
    private final boolean trailDelimiter;
    private final boolean withTrim;
    private final String lineSeparator;
    private final Character escapeCharacter;
    private final boolean skipHeader;
    private final StringBuilder sb;

    public CutRecordParserV2(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) {
        this.reader = new ExtendedBufferedReader(reader);
        this.nullString = nullString;
        this.columnSplitter = columnSplitter;
        this.trailDelimiter = trailDelimiter;
        this.escapeCharacter = escapeChar;
        this.withTrim = withTrim;
        this.lineSeparator = lineSeparator;
        this.skipHeader = skipHeader;
        this.sb = new StringBuilder(4096);
        this.skipRecordHeader();
    }

    public static CutRecordParserV2 parse(String string, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(string, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR);
    }

    public static CutRecordParserV2 parse(String string, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string is null");
        return CutRecordParserV2.parse(new StringReader(string), nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, false);
    }

    public static CutRecordParserV2 parse(File file, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(file, charset, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(File file, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParserV2.parse(Files.newInputStream(file.toPath(), new OpenOption[0]), charset, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(InputStream is, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(is, charset, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(InputStream is, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Column splitter is null");
        return CutRecordParserV2.parse(new InputStreamReader(is, charset), nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(Path path, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParserV2.parse(Files.newInputStream(path, new OpenOption[0]), charset, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, false);
    }

    public static CutRecordParserV2 parse(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(reader, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Input reader is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Input column splitter is null");
        return new CutRecordParserV2(reader, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(URL url, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        return CutRecordParserV2.parse(url.openStream(), charset, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    private void skipRecordHeader() {
        if (this.skipHeader) {
            try {
                Record record = this.nextRecord();
                this.fieldCount.set(0);
                log.info("Skip header: {} finish", record == null ? "<No Header>" : record.getValues());
            }
            catch (IOException e) {
                log.warn("Skip header failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record nextRecord() throws IOException {
        ArrayList<String> values = new ArrayList<String>(this.fieldCount.get());
        try {
            int dt = -1;
            while ((dt = this.reader.read()) != -1) {
                char nextChar2;
                int i;
                int limit;
                char ch = (char)dt;
                if (ch == this.lineSeparator.charAt(0)) {
                    limit = this.lineSeparator.length() - 1;
                    if (limit > 0) {
                        this.reader.mark(limit);
                        for (i = 0; i < limit; ++i) {
                            nextChar2 = (char)this.reader.read();
                            if (nextChar2 == this.lineSeparator.charAt(i + 1)) continue;
                            this.reader.reset();
                            break;
                        }
                    }
                    if (i == limit) {
                        if (this.fieldCount.get() == 0 || values.size() == this.fieldCount.get() - 1) {
                            this.addValue(values, this.sb.toString());
                            this.fieldCount.compareAndSet(0, values.size());
                            break;
                        }
                        if (this.fieldCount.get() > 0 && values.size() >= this.fieldCount.get()) {
                            this.addValue(values, this.sb.toString());
                            Record nextChar2 = new Record(String.join((CharSequence)this.columnSplitter, values), values, "Column count unmatched");
                            return nextChar2;
                        }
                        if (this.fieldCount.get() <= 0 || values.size() >= this.fieldCount.get() - 1) continue;
                        this.sb.append(ch);
                        continue;
                    }
                }
                if (ch == this.columnSplitter.charAt(0)) {
                    limit = this.columnSplitter.length() - 1;
                    if (limit > 0) {
                        this.reader.mark(limit);
                        for (i = 0; i < limit; ++i) {
                            nextChar2 = (char)this.reader.read();
                            if (nextChar2 == this.columnSplitter.charAt(i + 1)) continue;
                            this.reader.reset();
                            break;
                        }
                    }
                    if (i == limit) {
                        this.addValue(values, this.sb.toString());
                        continue;
                    }
                    this.sb.append(ch);
                    continue;
                }
                if (this.escapeCharacter != null && ch == this.escapeCharacter.charValue()) {
                    this.reader.mark(1);
                    char nextChar3 = (char)this.reader.read();
                    if (nextChar3 == this.columnSplitter.charAt(0) || nextChar3 == this.lineSeparator.charAt(0)) {
                        this.sb.append(nextChar3);
                        continue;
                    }
                    if (nextChar3 == this.escapeCharacter.charValue()) {
                        this.sb.append(ch);
                        this.sb.append(nextChar3);
                        continue;
                    }
                    this.sb.append(ch);
                    this.reader.reset();
                    continue;
                }
                this.sb.append(ch);
            }
            if (!(dt != -1 || values.size() <= 0 && this.sb.length() <= 0 || this.fieldCount.get() != 0 && values.size() > this.fieldCount.get())) {
                if (this.sb.length() > 0 && this.sb.toString().endsWith(this.lineSeparator)) {
                    this.sb.delete(this.sb.length() - this.lineSeparator.length(), this.sb.length());
                }
                this.addValue(values, this.sb.toString());
                int tmpFieldCount = this.fieldCount.get();
                this.fieldCount.set(0);
                if (values.size() < tmpFieldCount) {
                    Record record = new Record(String.join((CharSequence)this.columnSplitter, values), values, "Column count unmatched");
                    return record;
                }
            }
            if (this.trailDelimiter && values.size() > 0) {
                values.remove(values.size() - 1);
            }
            Record record = values.isEmpty() ? null : new Record(values, 0L);
            return record;
        }
        catch (Exception e) {
            Record record = new Record(Lists.newArrayList(), -1L);
            return record;
        }
        finally {
            if (this.sb.length() > 0) {
                this.sb.setLength(0);
            }
        }
    }

    private void addValue(List<String> values, String toString) {
        String value = this.withTrim ? toString.trim() : toString;
        value = this.unescapeValues(value, this.escapeCharacter != null);
        values.add(value);
        if (this.sb.length() > 0) {
            this.sb.setLength(0);
        }
    }

    private String unescapeValues(String str, boolean isEscaped) {
        String nullString = this.getNullString();
        if (nullString != null && StringUtils.equals(str, nullString)) {
            return null;
        }
        if (!isEscaped) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int len = str.length();
        boolean isEscapedChar = true;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == this.escapeCharacter.charValue() && isEscapedChar) {
                isEscapedChar = false;
                continue;
            }
            sb.append(c);
            isEscapedChar = true;
        }
        return this.isWithTrim() ? sb.toString().trim() : sb.toString();
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        if (this.reader != null) {
            this.reader.close();
        }
        this.sb.setLength(0);
        super.close();
    }

    public String getNullString() {
        return this.nullString;
    }

    public String getColumnSplitter() {
        return this.columnSplitter;
    }

    public boolean isTrailDelimiter() {
        return this.trailDelimiter;
    }

    public boolean isWithTrim() {
        return this.withTrim;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }
}

