/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.reader.schema;

import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.NamedThreadFactory;
import com.oceanbase.tools.loaddump.manager.session.SessionOption;
import com.oceanbase.tools.loaddump.parser.schema.SchemaFileParser;
import com.oceanbase.tools.loaddump.reader.AbstractFileReader;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileReader
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileReader.class);
    private static final Logger BAD_SCHEMA_SQL_LOGGER = LoggerFactory.getLogger((String)"BadSchemaLogger");
    protected int threads;
    protected ServerMode serverMode;
    protected DataFormat dataFormat;
    protected boolean replaceObjectIfExists;
    protected Map<ObjectType, List<SubFile>> subFilesMap;
    protected Map<SubFile, List<Integer>> retrySqls = new ConcurrentHashMap<SubFile, List<Integer>>();

    public SchemaFileReader(LoadParameter parameter) {
        super(parameter);
        this.threads = parameter.getThreads();
        this.dataFormat = parameter.getDataFormat();
        this.serverMode = parameter.getDatabase().getServerMode();
        this.replaceObjectIfExists = parameter.isReplaceObjectIfExists();
        this.subFilesMap = new HashMap<ObjectType, List<SubFile>>(parameter.getSubFiles().size());
        for (SubFile subFile : parameter.getSubFiles()) {
            this.subFilesMap.computeIfAbsent(ObjectType.valueOfName(subFile.getObjectType()), v -> new ArrayList()).add(subFile);
        }
    }

    @Override
    public void run() {
        ConcurrentHashMap<ObjectType, List> retrySubFilesMap = new ConcurrentHashMap<ObjectType, List>();
        try (Connection conn = this.connectionKey.getSessionManager().createNewConnection(true, new SessionOption[0]);){
            JdbcUtils.setForeignKeyChecks(conn, false);
            for (Map.Entry<ObjectType, List<SubFile>> subFileList : this.subFilesMap.entrySet()) {
                retrySubFilesMap.put(subFileList.getKey(), new ArrayList(subFileList.getValue()));
            }
            boolean success = false;
            int maxRetryTimes = ObjectType.DEPENDENCIES.length;
            for (int retryTimes = 0; retryTimes < maxRetryTimes && !success; ++retryTimes) {
                success = true;
                boolean shouldFinish = retryTimes == maxRetryTimes - 1;
                for (ObjectType objectType : ObjectType.DEPENDENCIES) {
                    SubFile subFile;
                    List subFiles = (List)retrySubFilesMap.get((Object)objectType);
                    if (CollectionUtils.isEmpty((Collection)subFiles)) {
                        if (retryTimes != 0) continue;
                        log.warn("The object type: \"{}\" doesn't exist in the -schema.sql files", (Object)objectType);
                        continue;
                    }
                    Iterator iter = subFiles.iterator();
                    ExecutorTemplate<Void> executorTemplate = new ExecutorTemplate<Void>(new ThreadPoolExecutor(this.threads, this.threads, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000), new NamedThreadFactory("Resolve-Ddl-Task")));
                    log.info("Start {} schema file loader threads success", (Object)this.threads);
                    while (this.supervisor.get() && iter.hasNext()) {
                        subFile = (SubFile)iter.next();
                        subFile.setTaskState(TaskState.INITIAL);
                        executorTemplate.submit(() -> {
                            this.parseSqlsOfSubFile(subFile, shouldFinish);
                            return null;
                        });
                    }
                    executorTemplate.waitForResult();
                    iter = subFiles.iterator();
                    while (this.supervisor.get() && iter.hasNext()) {
                        subFile = (SubFile)iter.next();
                        if (!subFile.isRetry()) {
                            iter.remove();
                            continue;
                        }
                        subFile.setRetry(false);
                        if (retryTimes < maxRetryTimes - 1) {
                            log.warn("Retry to Load schema :\"{}\" . As: Lack of Dependency", (Object)subFile.getFilePath());
                        }
                        success = false;
                        if (retryTimes != maxRetryTimes - 1) continue;
                        log.error("Load schema :\"{}\" . As: Lack of Dependency", (Object)subFile.getFilePath());
                        String objectName = subFile.getObjectName();
                        if (!this.globalContext.incrementAndIsExceedMaxErrors(objectName)) continue;
                        log.error("The max errors of \"{}-{}\" is exceeded, loading {} failed\n", new Object[]{objectType, objectName, objectName});
                    }
                }
            }
            JdbcUtils.setForeignKeyChecks(conn, true);
        }
        catch (Exception ex) {
            try {
                retrySubFilesMap.forEach((k, v) -> v.forEach(e -> {
                    e.setTaskState(TaskState.FAILURE);
                    super.updateTaskDetail((SubFile)e);
                }));
            }
            catch (Throwable t) {
                log.error("Update the detail of task failed. Reason:{}", (Object)t.getMessage());
            }
            log.error("Load schema failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSqlsOfSubFile(SubFile subFile, boolean shouldFinish) {
        block42: {
            block41: {
                subFilePath = subFile.getUniquePath();
                endIndex = subFilePath.lastIndexOf(File.separator);
                if (endIndex > -1) {
                    subFilePath = subFilePath.substring(endIndex + 1);
                }
                isOracleMode = ServerMode.ORACLE.equals((Object)this.serverMode);
                conn = null;
                try {
                    stream = subFile.openBoundedStream(null);
                    var8_12 = null;
                    try {
                        sqls = new SchemaFileParser(isOracleMode).batchReadSql(stream, this.fileEncoding);
                        subFile.setTotalSize(FileUtils.getSize(subFile.getFilePath()));
                        subFile.getParsedCount().getAndSet(sqls.size());
                        if (CollectionUtils.isEmpty(sqls)) {
                            subFile.setTaskState(TaskState.FAILURE);
                            subFile.setMessage("Statements are empty which parsed from: \"" + subFilePath + "\"");
                            SchemaFileReader.log.warn(subFile.getMessage());
                            break block41;
                        }
                        if (!this.retrySqls.containsKey(subFile)) {
                            this.retrySqls.put(subFile, Stream.iterate(0, (UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseSqlsOfSubFile$4(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/Integer;)()).limit(sqls.size()).collect(Collectors.toList()));
                        }
                        status = true;
                        lastReason = new StringBuilder();
                        conn = this.connectionKey.getSessionManager().createNewConnection(true, new SessionOption[0]);
                        isMixFormat = DataFormat.MIX == this.dataFormat;
                        retrySqlIndex = this.retrySqls.get(subFile);
                        for (j = 0; this.supervisor.get() && j < sqls.size(); ++j) {
                            sql = sqls.get(j);
                            if (this.skipEmptySqls(retrySqlIndex, j, sql, isMixFormat)) continue;
                            try {
                                status &= this.parseSingleSql(sql, conn, subFile, retrySqlIndex, j, lastReason);
                                continue;
                            }
                            catch (Exception e) {
                                if (e instanceof TimeoutException) {
                                    JdbcUtils.close(conn);
                                    conn = this.connectionKey.getSessionManager().createNewConnection(true, new SessionOption[0]);
                                    JdbcUtils.setForeignKeyChecks(conn, false);
                                }
                                status = false;
                            }
                        }
                        if (shouldFinish || !subFile.isRetry()) {
                            subFile.setMessage(lastReason.toString());
                            subFile.setTaskState(status != false ? TaskState.SUCCESS : TaskState.FAILURE);
                            super.updateTaskDetail(subFile);
                            for (int index : retrySqlIndex) {
                                SchemaFileReader.BAD_SCHEMA_SQL_LOGGER.error(sqls.get(index) + ";");
                            }
                            SchemaFileReader.log.info("Load file: \"{}\" {}", (Object)subFilePath, (Object)(status != false ? "succeeded" : "failed"));
                        }
                        break block42;
                    }
                    catch (Throwable var9_15) {
                        var8_12 = var9_15;
                        throw var9_15;
                    }
                    finally {
                        if (stream != null) {
                            if (var8_12 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable var10_16) {
                                    var8_12.addSuppressed(var10_16);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    subFile.setTaskState(TaskState.FAILURE);
                    subFile.setMessage(ExceptionUtils.getRootCauseMessage(e));
                    SchemaFileReader.log.error("Load file: \"{}\" failed. Reason :{}", (Object)subFilePath, (Object)e.getMessage());
                    return;
                }
                ** finally { 
lbl73:
                // 1 sources

                ** GOTO lbl-1000
            }
            while (this.supervisor.get() && (shouldFinish || !subFile.isRetry()) && !subFile.isFinished()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception var10_18) {}
            }
            JdbcUtils.close(conn);
            super.updateTaskDetail(subFile);
            return;
        }
        while (this.supervisor.get() && (shouldFinish || !subFile.isRetry()) && !subFile.isFinished()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception stream) {}
        }
        JdbcUtils.close(conn);
        super.updateTaskDetail(subFile);
        return;
lbl-1000:
        // 3 sources

        {
            while (this.supervisor.get() && (shouldFinish || !subFile.isRetry()) && !subFile.isFinished()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception var7_11) {}
            }
            JdbcUtils.close(conn);
            super.updateTaskDetail(subFile);
        }
    }

    private boolean skipEmptySqls(List<Integer> retrySqlIndex, Integer originIndex, String sql, boolean isMixFormat) {
        if (!retrySqlIndex.contains(originIndex)) {
            return true;
        }
        if (StringUtils.isBlank(sql)) {
            retrySqlIndex.remove(originIndex);
            return true;
        }
        if (!isMixFormat && !this.replaceObjectIfExists && JdbcUtils.isDropSql(sql)) {
            log.warn("Skip to exec sql: \"{}\" . As --replace-object is false", (Object)sql);
            retrySqlIndex.remove(originIndex);
            return true;
        }
        return false;
    }

    private boolean parseSingleSql(String sql, Connection conn, SubFile subFile, List<Integer> retrySqlIndex, Integer originIndex, StringBuilder lastReason) throws Exception {
        boolean status;
        block10: {
            status = true;
            try {
                Throwable th;
                if (DataFormat.MIX != this.dataFormat) {
                    sql = JdbcUtils.removeIncompatibleSnippet(sql);
                }
                Stopwatch stopwatch = Stopwatch.createStarted();
                SupplierResult sr = this.supplyAsync(conn, sql);
                if (sr.isSuccess()) {
                    retrySqlIndex.remove(originIndex);
                    log.info("No.{} sql of the file: \"{}\" exec {}. Elapsed: {}", new Object[]{originIndex + 1, subFile.getUniquePath(), sr.getDesc(), stopwatch.stop()});
                }
                if ((th = sr.getRootCause()) != null) {
                    throw th;
                }
                subFile.addLoadedCount(sr.isSuccess() ? 1 : 0);
            }
            catch (Throwable e) {
                boolean isTimeOut = e instanceof TimeoutException;
                String msg = ExceptionUtils.getRootCauseMessage(e);
                if (this.ignoreExecuteSql(sql, msg, retrySqlIndex, originIndex)) {
                    return true;
                }
                if (JdbcUtils.isCreateExistsObjectError(sql, msg)) {
                    status = this.tryToCreateOnExists(sql, msg, subFile, conn, retrySqlIndex, originIndex);
                    if (!status) {
                        lastReason.delete(0, lastReason.length());
                        lastReason.append(msg);
                    }
                    return status;
                }
                if (JdbcUtils.isCreateWithoutDependenciesError(msg)) {
                    subFile.setRetry(true);
                    lastReason.delete(0, lastReason.length());
                    lastReason.append(msg);
                    return false;
                }
                status = false;
                StringBuilder sb = new StringBuilder();
                sb.append("No.").append(originIndex + 1).append(" sql of the file: \"");
                sb.append(subFile.getUniquePath()).append("\" exec ").append(isTimeOut ? "timeout. " : "failed. ");
                sb.append("Reason: ").append(msg).append(". SQL: ").append(sql).append(";\n");
                if (this.globalContext.incrementAndIsExceedMaxErrors(subFile.getObjectName())) {
                    log.error("The max error : \"{}\" is exceeded, loading task will be stop....", (Object)this.globalContext.getErrorCount(subFile.getObjectName()));
                    throw new Exception(sb.toString());
                }
                lastReason.delete(0, lastReason.length());
                log.error(lastReason.append((CharSequence)sb).toString());
                if (!isTimeOut) break block10;
                throw new TimeoutException();
            }
        }
        return status;
    }

    private boolean ignoreExecuteSql(String sql, String msg, List<Integer> retrySqlIndex, Integer originIndex) {
        if (JdbcUtils.isDropNonExistsObjectError(sql, msg)) {
            retrySqlIndex.remove(originIndex);
            return true;
        }
        if (msg != null && (msg.contains("Duplicate entry") || msg.contains("unique constraint"))) {
            retrySqlIndex.remove(originIndex);
            return true;
        }
        return false;
    }

    private boolean tryToCreateOnExists(String sql, String message, SubFile subFile, Connection conn, List<Integer> retrySqlIndex, Integer originIndex) throws Exception {
        boolean status = true;
        if (this.replaceObjectIfExists) {
            List<Throwable> throwables = this.replaceObjectIfExists(subFile, conn, sql);
            StringBuilder sb = new StringBuilder();
            for (Throwable th : throwables) {
                status = false;
                sb.append(ExceptionUtils.getRootCauseMessage(th)).append("\n");
            }
            if (!status && !throwables.isEmpty()) {
                if (this.globalContext.incrementAndIsExceedMaxErrors(subFile.getObjectName())) {
                    log.error("The max error : \"{}\" is exceeded, loading task will be stop", (Object)this.globalContext.getErrorCount(subFile.getObjectName()));
                    throw new Exception(sb.toString());
                }
                log.error("Replace object if exists failed. Error: {}. SQL: {};\n", (Object)sb, (Object)sql);
            } else {
                subFile.addLoadedCount(1);
                retrySqlIndex.remove(originIndex);
            }
        } else {
            log.warn("No.{} sql of the file: \"{}\" exec failed. Warn: {}. SQL: {};\n", new Object[]{originIndex + 1, subFile.getUniquePath(), message, sql});
            status = false;
        }
        return status;
    }

    private List<Throwable> replaceObjectIfExists(SubFile subFile, Connection conn, String create) {
        StringBuilder object = new StringBuilder(256);
        if (ObjectType.FILE.name().equals(subFile.getObjectType())) {
            List<String> tokens = this.doSimpleParse(create);
            object.append(tokens.get(0)).append(" ").append(tokens.get(1));
        } else {
            object.append(subFile.getObjectType().toLowerCase(Locale.getDefault()));
            object.append(" ");
            if (!subFile.getObjectType().equals(ObjectType.TABLE_GROUP.getName()) && !subFile.getObjectType().equals(ObjectType.PUBLIC_SYNONYM.getName())) {
                object.append(this.serverMode.wrapName(subFile.getSchemaName())).append(".");
            }
            object.append(this.serverMode.wrapName(subFile.getObjectName()));
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        Stopwatch stopwatch = Stopwatch.createStarted();
        StringBuilder drop = new StringBuilder("drop ").append((CharSequence)object).append(";");
        SupplierResult sr = this.supplyAsync(conn, drop.toString());
        String message = ExceptionUtils.getRootCauseMessage(sr.getRootCause());
        if (!message.contains("does not exist")) {
            CollectionUtils.addIgnoreNull(throwables, (Object)sr.getRootCause());
        }
        log.info("Exec \" {} \" {} . Elapsed: {}", new Object[]{drop, sr.getDesc(), stopwatch.stop()});
        stopwatch = Stopwatch.createStarted();
        SupplierResult sr2 = this.supplyAsync(conn, create);
        CollectionUtils.addIgnoreNull(throwables, (Object)sr2.getRootCause());
        log.info("Replace \" {} \" {}. Elapsed: {}", new Object[]{object, sr2.getDesc(), stopwatch.stop()});
        return throwables;
    }

    public List<String> doSimpleParse(@NonNull String sql) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        try (StringReader sr = new StringReader(sql);){
            int state = 0;
            int ch = -1;
            int i = 0;
            char[] chars = new char[256];
            while ((ch = sr.read()) != -1) {
                char[] temp;
                if (ch == 32 || ch == 10 || ch == 13) {
                    if (state == 0) continue;
                    temp = new char[i];
                    System.arraycopy(chars, 0, temp, 0, i);
                    String token = new String(temp);
                    if (!("create".equalsIgnoreCase(token) || "or".equalsIgnoreCase(token) || "replace".equalsIgnoreCase(token))) {
                        tokens.add(token);
                    }
                    state = 0;
                    i = 0;
                    chars = new char[256];
                    continue;
                }
                if (i > chars.length - 1) {
                    temp = new char[512];
                    System.arraycopy(chars, 0, temp, 0, chars.length);
                    chars = temp;
                }
                chars[i++] = (char)ch;
                state = 1;
                if (tokens.size() != 2) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Parse ddl failed", e);
        }
        return tokens;
    }

    private SupplierResult supplyAsync(Connection conn, String sql) {
        CompletableFuture<SupplierResult> cf = CompletableFuture.supplyAsync(() -> {
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.execute();
                SupplierResult supplierResult = new SupplierResult();
                return supplierResult;
            }
            catch (Exception ex) {
                return new SupplierResult(ex);
            }
        });
        try {
            return cf.get(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return new SupplierResult(e);
        }
    }

    private static /* synthetic */ Integer lambda$parseSqlsOfSubFile$4(Integer t) {
        return t + 1;
    }

    static class SupplierResult {
        private final Throwable throwable;

        public SupplierResult() {
            this.throwable = null;
        }

        public SupplierResult(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getRootCause() {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.throwable);
            return rootCause == null ? this.throwable : rootCause;
        }

        public boolean isSuccess() {
            return this.throwable == null;
        }

        public String getDesc() {
            return this.isSuccess() ? "success" : "failed";
        }
    }
}

