/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.reader.schema;

import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.ObjectStatus;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.parser.compatilble.SqlText;
import com.oceanbase.tools.loaddump.parser.compatilble.mysqldump.MySqlDumpParser;
import com.oceanbase.tools.loaddump.reader.AbstractFileReader;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileReaderV2
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileReaderV2.class);
    private static final Logger BAD_SCHEMA_SQL_LOGGER = LoggerFactory.getLogger((String)"BadSchemaLogger");
    protected int threads;
    protected ServerMode serverMode;
    protected DataFormat dataFormat;
    protected boolean ignoreComment;
    protected boolean replaceObjectIfExists;
    protected List<String> objectNames;
    protected Map<ObjectType, List<SubFile>> subFilesMap;
    protected Map<SubFile, List<Integer>> retrySqls = new ConcurrentHashMap<SubFile, List<Integer>>();

    public SchemaFileReaderV2(LoadParameter parameter) {
        super(parameter);
        this.threads = parameter.getThreads();
        this.dataFormat = parameter.getDataFormat();
        this.serverMode = parameter.getDatabase().getServerMode();
        this.replaceObjectIfExists = parameter.isReplaceObjectIfExists();
        List<SubFile> subFileList = parameter.getSubFiles();
        this.objectNames = subFileList.stream().map(SubFile::getObjectName).collect(Collectors.toList());
        this.subFilesMap = this.sortByDependencies(subFileList);
    }

    private Map<ObjectType, List<SubFile>> sortByDependencies(List<SubFile> subFileList) {
        LinkedHashMap<ObjectType, List> temp = new LinkedHashMap<ObjectType, List>();
        for (SubFile subFile : subFileList) {
            ObjectType objectType = ObjectType.valueOfName(subFile.getObjectType());
            temp.computeIfAbsent(objectType, v -> new ArrayList()).add(subFile);
        }
        LinkedHashMap<ObjectType, List<SubFile>> subFileListMap = new LinkedHashMap<ObjectType, List<SubFile>>();
        for (ObjectType objectType : ObjectType.DEPENDENCIES) {
            List tempSubFileList = (List)temp.remove((Object)objectType);
            if (!CollectionUtils.isNotEmpty((Collection)tempSubFileList)) continue;
            subFileListMap.put(objectType, tempSubFileList);
        }
        return subFileListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<ObjectType, List<SubFile>> executableMap = this.subFilesMap;
        String[] errors = new String[1];
        int retryTimes = 0;
        int currentExecCount = 0;
        int prevRetryCount = executableMap.values().stream().mapToInt(List::size).sum();
        try {
            while (MapUtils.isNotEmpty(executableMap) && prevRetryCount > currentExecCount) {
                LinkedHashMap<ObjectType, List<SubFile>> retryFailedMap = new LinkedHashMap<ObjectType, List<SubFile>>();
                for (Map.Entry<ObjectType, List<SubFile>> entry : executableMap.entrySet()) {
                    retryFailedMap.putAll(this.handleSqlFormatFile(entry.getKey(), entry.getValue()));
                }
                prevRetryCount = executableMap.values().stream().mapToInt(List::size).sum();
                executableMap = retryFailedMap;
                currentExecCount = executableMap.values().stream().mapToInt(List::size).sum();
                ++retryTimes;
            }
        }
        catch (Exception ex) {
            try {
                errors[0] = ExceptionUtils.getRootCauseMessage(ex);
            }
            catch (Throwable throwable) {
                if (MapUtils.isNotEmpty(executableMap)) {
                    executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                        e.setTaskState(TaskState.FAILURE);
                        e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                        this.updateTaskDetail((SubFile)e);
                    });
                    String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
                    log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
                }
                throw throwable;
            }
            if (MapUtils.isNotEmpty(executableMap)) {
                executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                    e.setTaskState(TaskState.FAILURE);
                    e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                    this.updateTaskDetail((SubFile)e);
                });
                String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
                log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
            }
        }
        if (MapUtils.isNotEmpty(executableMap)) {
            executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                e.setTaskState(TaskState.FAILURE);
                e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                this.updateTaskDetail((SubFile)e);
            });
            String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
            log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ObjectType, List<SubFile>> handleSqlFormatFile(ObjectType objectType, List<SubFile> subFileList) {
        boolean isCompatibleWith3rd = this.dataFormat == DataFormat.MIX;
        LinkedHashMap<ObjectType, List<SubFile>> retryFailedMap = new LinkedHashMap<ObjectType, List<SubFile>>();
        for (SubFile subFile : subFileList) {
            subFile.setTaskState(TaskState.RUNNING);
            String subFilePath = subFile.getUniquePath();
            try {
                MySqlDumpParser parser = MySqlDumpParser.createParser(subFile.openBoundedStream(this.fileEncoding), this.ignoreComment);
                Throwable throwable = null;
                try {
                    parser.setCompatibleWith3rd(isCompatibleWith3rd);
                    List<SqlText> sqlTextList = parser.parseStmt();
                    if (CollectionUtils.isEmpty(sqlTextList)) {
                        log.warn("No statements are parsed from: \"{}\"", (Object)subFilePath);
                        subFile.setTaskState(TaskState.FAILURE);
                        subFile.setMessage("No statements are parsed from: \"" + subFilePath + "\"");
                        continue;
                    }
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    subFile.setTotalSize(FileUtils.getSize(subFile.getFilePath()));
                    subFile.getParsedCount().getAndSet(sqlTextList.size());
                    int totalCount = sqlTextList.size();
                    for (int i = 0; i < totalCount; ++i) {
                        SqlText sqlText = sqlTextList.get(i);
                        try {
                            if (sqlText.isSupported()) {
                                sqlText.setObjectType(subFile.getObjectType());
                                sqlText.setSchemaName(subFile.getSchemaName());
                                sqlText.setObjectName(subFile.getObjectName());
                                subFile.addLoadedCount(this.executeSqlStatement(subFilePath, i + 1, totalCount, sqlText));
                                continue;
                            }
                            subFile.addLoadedCount(1);
                            log.warn("SQL-format file: \"{}\" appears an unsupported {}.", (Object)subFilePath, (Object)sqlText);
                            continue;
                        }
                        catch (Throwable th) {
                            String error = ExceptionUtils.getRootCauseMessage(th);
                            String executableSql = sqlText.getExecutableSql();
                            if (isCompatibleWith3rd) {
                                subFile.setTaskState(TaskState.FAILURE);
                                if (StringUtils.isBlank(subFile.getMessage())) {
                                    subFile.setMessage("Loading SQL-format file: \"" + subFilePath + "\" failure. Reason: " + error + ". Please see ../logs/ob-loader-dumper.error");
                                }
                                log.error("....Loading sql of SQL-format file: \"{}\" exec failure. ({}/{}). Reason: {}. SQL: {}", new Object[]{subFilePath, i + 1, totalCount, error, executableSql});
                                continue;
                            }
                            if (JdbcUtils.isCreateWithoutDependenciesError(error)) {
                                subFile.setTaskState(TaskState.INITIAL);
                                subFile.setMessage(error + ". SQL-format file: \"" + subFilePath + "\". SQL: " + executableSql);
                                retryFailedMap.computeIfAbsent(objectType, v -> new ArrayList()).add(subFile);
                                break;
                            }
                            subFile.setTaskState(TaskState.FAILURE);
                            subFile.setMessage("Loading SQL-format file: \"" + subFilePath + "\" failure. Reason: " + error + ". Please see ../logs/ob-loader-dumper.error");
                            log.error("....Loading sql of SQL-format file: \"{}\" exec failure. ({}/{}). Reason: {}. SQL: {}", new Object[]{subFilePath, i + 1, totalCount, error, executableSql});
                            break;
                        }
                    }
                    if (subFile.getTaskState() != TaskState.RUNNING) continue;
                    subFile.setTaskState(TaskState.SUCCESS);
                    log.info("Load SQL-format file: \"{}\" success. Total Elapsed: {}", (Object)subFilePath, (Object)stopwatch);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (parser == null) continue;
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    parser.close();
                }
            }
            catch (Throwable th) {
                subFile.setTaskState(TaskState.FAILURE);
                subFile.setMessage(ExceptionUtils.getRootCauseMessage(th));
                log.error("Process SQL-format file failed. Error: {}", (Object)subFile.getMessage(), (Object)th);
            }
            finally {
                this.updateTaskDetail(subFile);
            }
        }
        return retryFailedMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int executeSqlStatement(String filePath, int index, int total, SqlText sqlText) throws Exception {
        boolean retried = false;
        while (this.supervisor.get()) {
            String executableSql = JdbcUtils.removeIncompatibleSnippet(sqlText.getExecutableSql());
            try (Connection conn = this.connectionKey.getSessionManager().getPooledBizConnection();){
                JdbcUtils.setForeignKeyChecks(conn, true);
                SupplierResult sr = this.supplyAsync(conn, filePath, index, total, executableSql);
                if (sr.getRootCause() != null) {
                    throw sr.getRootCause();
                }
                JdbcUtils.setForeignKeyChecks(conn, false);
                int n = 1;
                return n;
            }
            catch (Throwable th) {
                String error = ExceptionUtils.getRootCauseMessage(th);
                if (JdbcUtils.isDropNonExistsObjectError(executableSql, error)) {
                    return 1;
                }
                if (JdbcUtils.isInsertDuplicateKeyError(executableSql, error)) {
                    return 1;
                }
                if (!retried && JdbcUtils.isExecuteTimeoutError(th, error)) {
                    retried = true;
                    continue;
                }
                if (!retried && JdbcUtils.isStatementSyntaxError(error)) {
                    sqlText.setTargetSqlText(this.etransfer(executableSql));
                    retried = true;
                    continue;
                }
                if (!retried && JdbcUtils.isCreateExistsObjectError(executableSql, error)) {
                    retried = this.shouldRetryStatement(sqlText);
                    if (retried) continue;
                    throw new SQLException(th);
                }
                throw new SQLException(th);
            }
        }
        return 0;
    }

    private String etransfer(String executableSql) {
        return executableSql;
    }

    private boolean shouldRetryStatement(SqlText sqlText) {
        if (!this.replaceObjectIfExists) {
            return false;
        }
        String objectType = sqlText.getObjectType();
        StringBuilder object = new StringBuilder(256);
        if (ObjectType.FILE.name().equals(objectType)) {
            List<String> tokens = this.doSimpleParse(sqlText.getExecutableSql());
            object.append(tokens.get(0)).append(" ").append(tokens.get(1));
        } else {
            object.append(objectType).append(" ");
            if (!ObjectType.TABLE_GROUP.getName().equals(objectType) && !ObjectType.PUBLIC_SYNONYM.getName().equals(objectType)) {
                object.append(this.serverMode.wrapName(sqlText.getSchemaName())).append(".");
            }
            object.append(this.serverMode.wrapName(sqlText.getObjectName()));
        }
        return this.tryDropObject("drop " + object);
    }

    /*
     * Exception decompiling
     */
    private boolean tryDropObject(String dropStmt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> doSimpleParse(@NonNull String sql) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        try (StringReader sr = new StringReader(sql);){
            int state = 0;
            int ch = -1;
            int i = 0;
            char[] chars = new char[256];
            while ((ch = sr.read()) != -1) {
                char[] temp;
                if (ch == 32 || ch == 10 || ch == 13) {
                    if (state == 0) continue;
                    temp = new char[i];
                    System.arraycopy(chars, 0, temp, 0, i);
                    String token = new String(temp);
                    if (!("create".equalsIgnoreCase(token) || "or".equalsIgnoreCase(token) || "replace".equalsIgnoreCase(token) || "if".equalsIgnoreCase(token) || "not".equalsIgnoreCase(token) || "exists".equalsIgnoreCase(token))) {
                        tokens.add(token);
                    }
                    state = 0;
                    i = 0;
                    chars = new char[256];
                    continue;
                }
                if (i > chars.length - 1) {
                    temp = new char[512];
                    System.arraycopy(chars, 0, temp, 0, chars.length);
                    chars = temp;
                }
                chars[i++] = (char)ch;
                state = 1;
                if (tokens.size() != 2) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Parse ddl failed", e);
        }
        return tokens;
    }

    private SupplierResult supplyAsync(Connection conn, String path, int index, int total, String sql) {
        try {
            return CompletableFuture.supplyAsync(() -> {
                log.debug("....Loading sql of SQL-format file: \"{}\" now. ({}/{}). SQLText: [{}]", new Object[]{path, index, total, sql});
                Stopwatch stopwatch = Stopwatch.createStarted();
                try {
                    SupplierResult supplierResult;
                    Object object;
                    Statement stmt;
                    block19: {
                        block20: {
                            stmt = conn.createStatement();
                            object = null;
                            stmt.execute(sql);
                            if (stopwatch.elapsed(TimeUnit.SECONDS) < 15L) {
                                log.info("....Loading sql of SQL-format file: \"{}\" exec success. ({}/{}). Elapsed: {}", new Object[]{path, index, total, stopwatch});
                            } else {
                                log.warn("....Loading sql of SQL-format file: \"{}\" exec slowly. ({}/{}). Elapsed: {}", new Object[]{path, index, total, stopwatch});
                            }
                            supplierResult = new SupplierResult();
                            if (stmt == null) break block19;
                            if (object == null) break block20;
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            break block19;
                        }
                        stmt.close();
                    }
                    return supplierResult;
                    catch (Throwable throwable) {
                        try {
                            try {
                                object = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (stmt != null) {
                                    if (object != null) {
                                        try {
                                            stmt.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)object).addSuppressed(throwable3);
                                        }
                                    } else {
                                        stmt.close();
                                    }
                                }
                                throw throwable2;
                            }
                        }
                        catch (Exception ex) {
                            object = new SupplierResult(ex);
                            return object;
                        }
                    }
                }
                finally {
                    stopwatch.stop();
                }
            }).get(15L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            return new SupplierResult(e);
        }
    }

    @Override
    protected void updateTaskDetail(@NonNull SubFile subFile) {
        if (subFile == null) {
            throw new NullPointerException("subFile is marked non-null but is null");
        }
        super.updateTaskDetail(subFile);
        subFile.getTaskDetail().setTaskType(TaskType.LOAD_SCHEMA);
        List<ObjectStatus> objectStatusList = subFile.getTaskDetail().getObjectStatusList();
        String objectName = subFile.getObjectName();
        String objectType = subFile.getObjectType();
        if (CollectionUtils.isNotEmpty(objectStatusList)) {
            Iterator<ObjectStatus> iter = objectStatusList.iterator();
            while (iter.hasNext()) {
                ObjectStatus objectStatus = iter.next();
                if (!objectStatus.getType().equals(objectType) || !objectStatus.getName().equals(objectName)) continue;
                iter.remove();
                break;
            }
        }
        objectStatusList.add(new ObjectStatus(objectName, objectType, subFile.getParsedCount(), subFile.getLoadedCount(), subFile.getTaskState()));
    }

    static class SupplierResult {
        private final Throwable throwable;

        public SupplierResult() {
            this.throwable = null;
        }

        public SupplierResult(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getRootCause() {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.throwable);
            return rootCause == null ? this.throwable : rootCause;
        }
    }
}

