/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.resource.ResourceFinder;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractResourceFinder<T>
implements ResourceFinder<T> {
    protected BaseParameter parameter;
    protected String filePath;
    protected String fileSuffix;
    protected String fileExtension;
    protected Pattern fileNameRegularExprPattern;
    protected final List<String> tableNames;
    protected final Map<String, String> sourceTargetTableMap;

    public AbstractResourceFinder(BaseParameter parameter) {
        this.parameter = parameter;
        this.filePath = parameter.getFilePath();
        if (parameter instanceof LoadParameter) {
            String fileNameRegularExpr;
            LoadParameter loadParameter = (LoadParameter)parameter;
            if (loadParameter.getInputFile() != null) {
                this.filePath = loadParameter.getInputFile().getAbsolutePath();
            }
            if (StringUtils.isNotBlank(fileNameRegularExpr = loadParameter.getFileNameRegExp())) {
                this.fileNameRegularExprPattern = Pattern.compile(fileNameRegularExpr);
            }
        }
        this.tableNames = parameter.getDatabase().getTableNames();
        this.sourceTargetTableMap = parameter.getSourceTargetTableMap();
        this.fileSuffix = parameter.getFileSuffix();
        this.fileExtension = this.fileSuffix.startsWith(".") ? this.fileSuffix.substring(1) : this.fileSuffix;
    }

    protected String binding0(Collection<String> tableNames, File file) {
        String tableName = DBUtils.extractObjectName(FileUtils.getTableName(file.getName()), null);
        if (JvmArgs.isBackupRestoreMode) {
            String targetTable = this.sourceTargetTableMap.get(tableName);
            return targetTable != null && tableNames.contains(targetTable) ? targetTable : null;
        }
        return tableNames.contains(tableName) ? tableName : null;
    }

    protected String binding1(Collection<String> tableNames, File file) {
        Preconditions.checkArgument((tableNames.size() == 1 ? 1 : 0) != 0, (String)"Specified table count=(%s) is unexpected. As --file-regular-expression is specified.", (int)tableNames.size());
        return this.fileNameRegularExprPattern.matcher(DBUtils.extractObjectName(file.getName(), null)).matches() ? tableNames.iterator().next() : null;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public Map<String, String> getSourceTargetTableMap() {
        return this.sourceTargetTableMap;
    }
}

