/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.s3;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.factory.S3TransferManagerPoolFactory;
import com.oceanbase.tools.loaddump.resource.remote.AbstractFileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileUploader
extends AbstractFileUploader {
    private static final Logger log = LoggerFactory.getLogger(S3FileUploader.class);
    private final S3StorageConfig config;
    private final GenericKeyedObjectPool<S3StorageConfig, TransferManager> tmPool;

    public S3FileUploader(S3StorageConfig config, String filePath) {
        this(config, filePath, false);
    }

    public S3FileUploader(S3StorageConfig config, String filePath, boolean useCustomPath) {
        super(filePath, useCustomPath);
        this.config = config;
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMinIdlePerKey(1);
        poolConfig.setMaxTotalPerKey(3);
        poolConfig.setFairness(true);
        this.tmPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new S3TransferManagerPoolFactory(), poolConfig);
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.AMAZON_S3;
    }

    @Override
    public void upload(File file) throws Exception {
        this.upload(file, null);
    }

    @Override
    public void upload(File file, Object progressListener) throws Exception {
        TransferManager tm = (TransferManager)this.tmPool.borrowObject((Object)this.config);
        String objectKey = this.assembleObjectKey(file, this.config.getPath());
        PutObjectRequest req = new PutObjectRequest(this.config.getBucket(), objectKey, file);
        req.setStorageClass(this.config.getStorageClass());
        if (progressListener instanceof ProgressListener) {
            req.setGeneralProgressListener((ProgressListener)progressListener);
        }
        try {
            Upload upload = tm.upload(req);
            upload.waitForCompletion();
            log.info("Upload \"{}\" succeed.", (Object)file.getAbsolutePath());
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                log.warn("Failed to delete local file \"{}\". Error: {}", (Object)file, (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Upload \"{}\" failed. Error: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            throw e;
        }
        finally {
            this.tmPool.returnObject((Object)this.config, (Object)tm);
            this.bytesWrittenMap.remove(file);
        }
    }

    @Override
    public String getDestUri() {
        return this.config.getUri();
    }

    @Override
    public void close() {
        this.tmPool.close();
    }
}

