/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IGrammar;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractConstraint
extends AbstractOwnership
implements IGrammar {
    public static final Map<String, String> DELETE_RULE_MAPPING = new HashMap<String, String>();
    public static final Map<String, String> UPDATE_RULE_MAPPING = new HashMap<String, String>();
    private final Collection<KeyColumn> constraintColumns = new ArrayList<KeyColumn>();
    private final Collection<KeyColumn> foreignColumns = new ArrayList<KeyColumn>();
    private final Collection<KeyColumn> referencedColumns = new ArrayList<KeyColumn>();
    private String constraintSchema;
    private String constraintName;
    private String constraintType;
    private String refTableOwner;
    private String refTableName;
    private String deleteRule;
    private String updateRule;

    public AbstractConstraint(AbstractSchema schema) {
        super(schema);
    }

    protected String getRefOwnerTableName() {
        StringBuilder sb = new StringBuilder();
        if (super.getGlobal().withSchema() || StringUtils.notEquals(this.getRefTableOwner(), this.getSchemaName())) {
            sb.append(this.wrap(this.getRefTableOwner())).append(".");
        }
        return sb.append(this.wrap(this.getRefTableName())).toString();
    }

    public StringBuilder joinConstraintColumns() {
        return this.enclose(this.getConstraintColumns().stream().map(e -> {
            String wrapped = this.wrap(e.getColumnName());
            String subPart = e.getSubPart();
            if (StringUtils.isNotBlank(subPart)) {
                wrapped = wrapped + "(" + subPart + ")";
            }
            return wrapped;
        }).collect(Collectors.joining(", ")));
    }

    public StringBuilder joinForeignConstraintColumns() {
        return this.enclose(this.getForeignColumns().stream().map(e -> this.wrap(e.getColumnName())).collect(Collectors.joining(", ")));
    }

    public StringBuilder joinRefConstraintColumns() {
        return this.enclose(this.getReferencedColumns().stream().map(e -> this.wrap(e.getColumnName())).collect(Collectors.joining(", ")));
    }

    public String buildUniqueReference() {
        StringBuilder key = new StringBuilder();
        key.append((CharSequence)this.joinForeignConstraintColumns());
        key.append(this.getRefTableOwner()).append(".").append(this.getRefTableName());
        return key.append((CharSequence)this.joinRefConstraintColumns()).toString();
    }

    public String toString() {
        return "AbstractConstraint(constraintColumns=" + this.getConstraintColumns() + ", foreignColumns=" + this.getForeignColumns() + ", referencedColumns=" + this.getReferencedColumns() + ", constraintSchema=" + this.getConstraintSchema() + ", constraintName=" + this.getConstraintName() + ", constraintType=" + this.getConstraintType() + ", refTableOwner=" + this.getRefTableOwner() + ", refTableName=" + this.getRefTableName() + ", deleteRule=" + this.getDeleteRule() + ", updateRule=" + this.getUpdateRule() + ")";
    }

    public AbstractConstraint() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractConstraint)) {
            return false;
        }
        AbstractConstraint other = (AbstractConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection<KeyColumn> this$constraintColumns = this.getConstraintColumns();
        Collection<KeyColumn> other$constraintColumns = other.getConstraintColumns();
        if (this$constraintColumns == null ? other$constraintColumns != null : !((Object)this$constraintColumns).equals(other$constraintColumns)) {
            return false;
        }
        Collection<KeyColumn> this$foreignColumns = this.getForeignColumns();
        Collection<KeyColumn> other$foreignColumns = other.getForeignColumns();
        if (this$foreignColumns == null ? other$foreignColumns != null : !((Object)this$foreignColumns).equals(other$foreignColumns)) {
            return false;
        }
        Collection<KeyColumn> this$referencedColumns = this.getReferencedColumns();
        Collection<KeyColumn> other$referencedColumns = other.getReferencedColumns();
        if (this$referencedColumns == null ? other$referencedColumns != null : !((Object)this$referencedColumns).equals(other$referencedColumns)) {
            return false;
        }
        String this$constraintSchema = this.getConstraintSchema();
        String other$constraintSchema = other.getConstraintSchema();
        if (this$constraintSchema == null ? other$constraintSchema != null : !this$constraintSchema.equals(other$constraintSchema)) {
            return false;
        }
        String this$constraintName = this.getConstraintName();
        String other$constraintName = other.getConstraintName();
        if (this$constraintName == null ? other$constraintName != null : !this$constraintName.equals(other$constraintName)) {
            return false;
        }
        String this$constraintType = this.getConstraintType();
        String other$constraintType = other.getConstraintType();
        if (this$constraintType == null ? other$constraintType != null : !this$constraintType.equals(other$constraintType)) {
            return false;
        }
        String this$refTableOwner = this.getRefTableOwner();
        String other$refTableOwner = other.getRefTableOwner();
        if (this$refTableOwner == null ? other$refTableOwner != null : !this$refTableOwner.equals(other$refTableOwner)) {
            return false;
        }
        String this$refTableName = this.getRefTableName();
        String other$refTableName = other.getRefTableName();
        if (this$refTableName == null ? other$refTableName != null : !this$refTableName.equals(other$refTableName)) {
            return false;
        }
        String this$deleteRule = this.getDeleteRule();
        String other$deleteRule = other.getDeleteRule();
        if (this$deleteRule == null ? other$deleteRule != null : !this$deleteRule.equals(other$deleteRule)) {
            return false;
        }
        String this$updateRule = this.getUpdateRule();
        String other$updateRule = other.getUpdateRule();
        return !(this$updateRule == null ? other$updateRule != null : !this$updateRule.equals(other$updateRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractConstraint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Collection<KeyColumn> $constraintColumns = this.getConstraintColumns();
        result = result * 59 + ($constraintColumns == null ? 43 : ((Object)$constraintColumns).hashCode());
        Collection<KeyColumn> $foreignColumns = this.getForeignColumns();
        result = result * 59 + ($foreignColumns == null ? 43 : ((Object)$foreignColumns).hashCode());
        Collection<KeyColumn> $referencedColumns = this.getReferencedColumns();
        result = result * 59 + ($referencedColumns == null ? 43 : ((Object)$referencedColumns).hashCode());
        String $constraintSchema = this.getConstraintSchema();
        result = result * 59 + ($constraintSchema == null ? 43 : $constraintSchema.hashCode());
        String $constraintName = this.getConstraintName();
        result = result * 59 + ($constraintName == null ? 43 : $constraintName.hashCode());
        String $constraintType = this.getConstraintType();
        result = result * 59 + ($constraintType == null ? 43 : $constraintType.hashCode());
        String $refTableOwner = this.getRefTableOwner();
        result = result * 59 + ($refTableOwner == null ? 43 : $refTableOwner.hashCode());
        String $refTableName = this.getRefTableName();
        result = result * 59 + ($refTableName == null ? 43 : $refTableName.hashCode());
        String $deleteRule = this.getDeleteRule();
        result = result * 59 + ($deleteRule == null ? 43 : $deleteRule.hashCode());
        String $updateRule = this.getUpdateRule();
        result = result * 59 + ($updateRule == null ? 43 : $updateRule.hashCode());
        return result;
    }

    public Collection<KeyColumn> getConstraintColumns() {
        return this.constraintColumns;
    }

    public Collection<KeyColumn> getForeignColumns() {
        return this.foreignColumns;
    }

    public Collection<KeyColumn> getReferencedColumns() {
        return this.referencedColumns;
    }

    public String getConstraintSchema() {
        return this.constraintSchema;
    }

    public void setConstraintSchema(String constraintSchema) {
        this.constraintSchema = constraintSchema;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(String constraintType) {
        this.constraintType = constraintType;
    }

    public String getRefTableOwner() {
        return this.refTableOwner;
    }

    public void setRefTableOwner(String refTableOwner) {
        this.refTableOwner = refTableOwner;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public void setRefTableName(String refTableName) {
        this.refTableName = refTableName;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(String deleteRule) {
        this.deleteRule = deleteRule;
    }

    public String getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(String updateRule) {
        this.updateRule = updateRule;
    }

    static {
        DELETE_RULE_MAPPING.put("C", " ON DELETE CASCADE");
        DELETE_RULE_MAPPING.put("N", " ON DELETE SET NULL");
        DELETE_RULE_MAPPING.put("R", " ON DELETE RESTRICT");
        DELETE_RULE_MAPPING.put("CASCADE", " ON DELETE CASCADE");
        DELETE_RULE_MAPPING.put("SET NULL", " ON DELETE SET NULL");
        DELETE_RULE_MAPPING.put("RESTRICT", " ON DELETE RESTRICT");
        DELETE_RULE_MAPPING.put("SET DEFAULT", " ON DELETE SET DEFAULT");
        UPDATE_RULE_MAPPING.put("R", " ON UPDATE RESTRICT");
        UPDATE_RULE_MAPPING.put("CASCADE", " ON UPDATE CASCADE");
        UPDATE_RULE_MAPPING.put("SET NULL", " ON UPDATE SET NULL");
        UPDATE_RULE_MAPPING.put("RESTRICT", " ON UPDATE RESTRICT");
        UPDATE_RULE_MAPPING.put("SET DEFAULT", " ON UPDATE SET DEFAULT");
    }
}

