/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractDatabaseLink;
import com.oceanbase.tools.loaddump.schema.AbstractDependency;
import com.oceanbase.tools.loaddump.schema.AbstractEvent;
import com.oceanbase.tools.loaddump.schema.AbstractFunction;
import com.oceanbase.tools.loaddump.schema.AbstractJob;
import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractPackage;
import com.oceanbase.tools.loaddump.schema.AbstractPackageBody;
import com.oceanbase.tools.loaddump.schema.AbstractProcedure;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractSequence;
import com.oceanbase.tools.loaddump.schema.AbstractSynonym;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.AbstractTableGroup;
import com.oceanbase.tools.loaddump.schema.AbstractTablespace;
import com.oceanbase.tools.loaddump.schema.AbstractTrigger;
import com.oceanbase.tools.loaddump.schema.AbstractType;
import com.oceanbase.tools.loaddump.schema.AbstractTypeBody;
import com.oceanbase.tools.loaddump.schema.AbstractView;
import com.oceanbase.tools.loaddump.schema.ObjectRelationGraph;
import com.oceanbase.tools.loaddump.schema.base.IDefiner;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.utils.ClassUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabase
extends AbstractOwnership
implements IDefiner {
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabase.class);

    public AbstractDatabase(AbstractSchema schema) {
        super(schema);
    }

    public boolean isTablespaceSupported() {
        return true;
    }

    public boolean isTableGroupSupported() {
        return true;
    }

    public boolean isSequenceSupported() {
        return true;
    }

    public boolean isAliasSupported() {
        return true;
    }

    public boolean isTriggerSupported() {
        return true;
    }

    public boolean isDbLinkSupported() {
        return true;
    }

    public boolean isSynonymSupported() {
        return true;
    }

    public boolean isFunctionSupported() {
        return true;
    }

    public boolean isProcedureSupported() {
        return true;
    }

    public boolean isTypeSupported() {
        return true;
    }

    public boolean isTypeBodySupported() {
        return true;
    }

    public boolean isPackageSupported() {
        return true;
    }

    public boolean isPackageBodySupported() {
        return true;
    }

    public boolean isMaterializedViewSupported() {
        return true;
    }

    public Class<? extends AbstractTablespace> resolveTablespaceClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTableGroup> resolveTableGroupClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTable> resolveTableClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractView> resolveViewClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSequence> resolveSequenceClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTrigger> resolveTriggerClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractFunction> resolveFunctionClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractProcedure> resolveProcedureClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSynonym> resolveAliasClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSynonym> resolveSynonymClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractDatabaseLink> resolveDbLinkClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractType> resolveTypeClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTypeBody> resolveTypeBodyClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractPackage> resolvePackageClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractPackageBody> resolvePackageBodyClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractTablespace acquireTablespace(String tablespaceName) {
        return this.acquireTablespaceMapping().get(tablespaceName);
    }

    public AbstractTableGroup acquireTableGroup(String tableGroupName) {
        return this.acquireTableGroupMapping().get(tableGroupName);
    }

    public AbstractTable acquireTable(String tableName) {
        return this.acquireTableMapping().get(tableName);
    }

    public AbstractView acquireView(String viewName) {
        return this.acquireViewMapping().get(viewName);
    }

    public AbstractSequence acquireSequence(String sequenceName) {
        return this.acquireSequenceMapping().get(sequenceName);
    }

    public AbstractTrigger acquireTrigger(String triggerName) {
        return this.acquireTriggerMapping().get(triggerName);
    }

    public AbstractFunction acquireFunction(String functionName) {
        return this.acquireFunctionMapping().get(functionName);
    }

    public AbstractProcedure acquireProcedure(String procedureName) {
        return this.acquireProcedureMapping().get(procedureName);
    }

    public AbstractSynonym acquireAlias(String aliasName) {
        return this.acquireAliasMapping().get(aliasName);
    }

    public AbstractSynonym acquireSynonym(String synonymName) {
        return this.acquireSynonymMapping().get(synonymName);
    }

    public AbstractDatabaseLink acquireDbLink(String dbLinkName) {
        return this.acquireDbLinkMapping().get(dbLinkName);
    }

    public AbstractType acquireType(String typeName) {
        return this.acquireTypeMapping().get(typeName);
    }

    public AbstractTypeBody acquireTypeBody(String typeBodyName) {
        return this.acquireTypeBodyMapping().get(typeBodyName);
    }

    public AbstractPackage acquirePackage(String packageName) {
        return this.acquirePackageMapping().get(packageName);
    }

    public AbstractPackageBody acquirePackageBody(String packageBodyName) {
        return this.acquirePackageBodyMapping().get(packageBodyName);
    }

    public List<? extends AbstractDependency> acquireDependencies() {
        log.warn("{} does't implement acquireDependencies()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Lists.newArrayList();
    }

    public Map<String, ? extends AbstractTablespace> acquireTablespaceMapping() {
        log.warn("{} does't implement acquireTablespaceMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractView> acquireViewMapping() {
        log.warn("{} does't implement acquireViewMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTableGroup> acquireTableGroupMapping() {
        log.warn("{} does't implement acquireTableGroupMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTable> acquireTableMapping() {
        log.warn("{} does't implement acquireTableMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractJob> acquireJobMapping() {
        log.warn("{} does't implement acquireJobMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractEvent> acquireEventMapping() {
        log.warn("{} does't implement acquireEventMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSynonym> acquireAliasMapping() {
        log.warn("{} does't implement acquireAliasMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSynonym> acquireSynonymMapping() {
        log.warn("{} does't implement acquireSynonymMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTrigger> acquireTriggerMapping() {
        log.warn("{} does't implement acquireTriggerMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSequence> acquireSequenceMapping() {
        log.warn("{} does't implement acquireSequenceMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractFunction> acquireFunctionMapping() {
        log.warn("{} does't implement acquireFunctionMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractProcedure> acquireProcedureMapping() {
        log.warn("{} does't implement acquireProcedureMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractDatabaseLink> acquireDbLinkMapping() {
        log.warn("{} does't implement acquireDatabaseLinkMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractType> acquireTypeMapping() {
        log.warn("{} does't implement acquireTypeMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTypeBody> acquireTypeBodyMapping() {
        log.warn("{} does't implement acquireTypeBodyMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractPackage> acquirePackageMapping() {
        log.warn("{} does't implement acquirePackageMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractPackageBody> acquirePackageBodyMapping() {
        log.warn("{} does't implement acquirePackageBodyMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        for (AbstractTablespace abstractTablespace : this.acquireTablespaceMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractTablespace.buildDefinition());
        }
        for (AbstractTable abstractTable : this.acquireTableMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractTable.buildDefinition());
        }
        for (AbstractTableGroup abstractTableGroup : this.acquireTableGroupMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractTableGroup.buildDefinition());
        }
        for (AbstractSequence abstractSequence : this.acquireSequenceMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractSequence.buildDefinition());
        }
        for (AbstractView abstractView : this.acquireViewMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractView.buildDefinition());
        }
        for (AbstractSynonym abstractSynonym : this.acquireSynonymMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractSynonym.buildDefinition());
        }
        for (AbstractType abstractType : this.acquireTypeMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractType.buildDefinition());
        }
        for (AbstractTypeBody abstractTypeBody : this.acquireTypeBodyMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractTypeBody.buildDefinition());
        }
        for (AbstractPackage abstractPackage : this.acquirePackageMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractPackage.buildDefinition());
        }
        for (AbstractPackageBody abstractPackageBody : this.acquirePackageBodyMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractPackageBody.buildDefinition());
        }
        for (AbstractTrigger abstractTrigger : this.acquireTriggerMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractTrigger.buildDefinition());
        }
        for (AbstractProcedure abstractProcedure : this.acquireProcedureMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractProcedure.buildDefinition());
        }
        for (AbstractFunction abstractFunction : this.acquireFunctionMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractFunction.buildDefinition());
        }
        for (AbstractDatabaseLink abstractDatabaseLink : this.acquireDbLinkMapping().values()) {
            CollectionUtils.addAllIgnoreNull(objectDefines, abstractDatabaseLink.buildDefinition());
        }
        return this.sortByDependencies(objectDefines);
    }

    @Override
    public String getQuotaCharacter() {
        return "";
    }

    public List<ObjectDefine> sortByDependencies(List<ObjectDefine> objectDefines) {
        List<? extends AbstractDependency> deps = this.acquireDependencies();
        if (CollectionUtils.isEmpty(deps) || CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        ObjectRelationGraph graph = new ObjectRelationGraph(deps.size());
        for (AbstractDependency abstractDependency : deps) {
            graph.add(abstractDependency.buildPredecessor(), abstractDependency.buildSuccessor());
        }
        return graph.groupByDepthFirst(objectDefines);
    }

    public String toString() {
        return "AbstractDatabase()";
    }

    public AbstractDatabase() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDatabase)) {
            return false;
        }
        AbstractDatabase other = (AbstractDatabase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDatabase;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

