/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;

public abstract class AbstractDependency
extends AbstractOwnership {
    private String objType;
    private String objName;
    private String refObjType;
    private String refObjOwner;
    private String refObjName;

    public AbstractDependency(AbstractSchema schema) {
        super(schema);
    }

    public StringBuilder buildPredecessor() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.getObjType() + "]");
        if (super.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        return sb.append(this.getObjName());
    }

    public StringBuilder buildSuccessor() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.getRefObjType() + "]");
        if (super.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        return sb.append(this.getRefObjName());
    }

    public AbstractDependency() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDependency)) {
            return false;
        }
        AbstractDependency other = (AbstractDependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$objType = this.getObjType();
        String other$objType = other.getObjType();
        if (this$objType == null ? other$objType != null : !this$objType.equals(other$objType)) {
            return false;
        }
        String this$objName = this.getObjName();
        String other$objName = other.getObjName();
        if (this$objName == null ? other$objName != null : !this$objName.equals(other$objName)) {
            return false;
        }
        String this$refObjType = this.getRefObjType();
        String other$refObjType = other.getRefObjType();
        if (this$refObjType == null ? other$refObjType != null : !this$refObjType.equals(other$refObjType)) {
            return false;
        }
        String this$refObjOwner = this.getRefObjOwner();
        String other$refObjOwner = other.getRefObjOwner();
        if (this$refObjOwner == null ? other$refObjOwner != null : !this$refObjOwner.equals(other$refObjOwner)) {
            return false;
        }
        String this$refObjName = this.getRefObjName();
        String other$refObjName = other.getRefObjName();
        return !(this$refObjName == null ? other$refObjName != null : !this$refObjName.equals(other$refObjName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDependency;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $objType = this.getObjType();
        result = result * 59 + ($objType == null ? 43 : $objType.hashCode());
        String $objName = this.getObjName();
        result = result * 59 + ($objName == null ? 43 : $objName.hashCode());
        String $refObjType = this.getRefObjType();
        result = result * 59 + ($refObjType == null ? 43 : $refObjType.hashCode());
        String $refObjOwner = this.getRefObjOwner();
        result = result * 59 + ($refObjOwner == null ? 43 : $refObjOwner.hashCode());
        String $refObjName = this.getRefObjName();
        result = result * 59 + ($refObjName == null ? 43 : $refObjName.hashCode());
        return result;
    }

    public String getObjType() {
        return this.objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getRefObjType() {
        return this.refObjType;
    }

    public void setRefObjType(String refObjType) {
        this.refObjType = refObjType;
    }

    public String getRefObjOwner() {
        return this.refObjOwner;
    }

    public void setRefObjOwner(String refObjOwner) {
        this.refObjOwner = refObjOwner;
    }

    public String getRefObjName() {
        return this.refObjName;
    }

    public void setRefObjName(String refObjName) {
        this.refObjName = refObjName;
    }
}

