/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.TableGroupPartition;
import com.oceanbase.tools.loaddump.schema.TableGroupSubPartition;
import com.oceanbase.tools.loaddump.schema.base.IDefiner;
import com.oceanbase.tools.loaddump.schema.base.IDelimiter;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public abstract class AbstractTableGroup
extends AbstractOwnership
implements IDefiner,
IDelimiter {
    private long tableGroupId;
    private String locality;
    private String primaryZone;
    private int partLevel;
    private String binding;
    private String comment;
    private int isSubPartTemplate = 1;
    private TableGroupPartition tableGroupPartition;

    public AbstractTableGroup(AbstractSchema schema) {
        super(schema);
    }

    protected StringBuilder buildTableGroupOptions() {
        StringBuilder sb = new StringBuilder(128);
        if (StringUtils.isNotBlank(this.getBinding())) {
            return sb.append("\nBINDING=").append(this.getBinding());
        }
        if (StringUtils.isNotBlank(this.getPrimaryZone())) {
            sb.append("\nPRIMARY_ZONE=").append(this.getPrimaryZone());
        }
        if (StringUtils.isNotBlank(this.getLocality())) {
            sb.append("\nLOCALITY='").append(this.getLocality()).append("'");
        }
        return sb;
    }

    protected StringBuilder buildTablePartitionOption() throws UnsupportedGrammarException {
        TableGroupPartition tableGroupPartition = this.getTableGroupPartition();
        if (tableGroupPartition == null) {
            return new StringBuilder(0);
        }
        return tableGroupPartition.buildGrammar();
    }

    public TableGroupSubPartition getTableGroupSubPartition() {
        if (this.tableGroupPartition == null) {
            throw new IllegalArgumentException("The tablegroup partition description is null");
        }
        return this.tableGroupPartition.getTableGroupSubPartition();
    }

    public AbstractTableGroup() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTableGroup)) {
            return false;
        }
        AbstractTableGroup other = (AbstractTableGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTableGroupId() != other.getTableGroupId()) {
            return false;
        }
        if (this.getPartLevel() != other.getPartLevel()) {
            return false;
        }
        if (this.getIsSubPartTemplate() != other.getIsSubPartTemplate()) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
            return false;
        }
        String this$primaryZone = this.getPrimaryZone();
        String other$primaryZone = other.getPrimaryZone();
        if (this$primaryZone == null ? other$primaryZone != null : !this$primaryZone.equals(other$primaryZone)) {
            return false;
        }
        String this$binding = this.getBinding();
        String other$binding = other.getBinding();
        if (this$binding == null ? other$binding != null : !this$binding.equals(other$binding)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        TableGroupPartition this$tableGroupPartition = this.getTableGroupPartition();
        TableGroupPartition other$tableGroupPartition = other.getTableGroupPartition();
        return !(this$tableGroupPartition == null ? other$tableGroupPartition != null : !((Object)this$tableGroupPartition).equals(other$tableGroupPartition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractTableGroup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $tableGroupId = this.getTableGroupId();
        result = result * 59 + (int)($tableGroupId >>> 32 ^ $tableGroupId);
        result = result * 59 + this.getPartLevel();
        result = result * 59 + this.getIsSubPartTemplate();
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        String $primaryZone = this.getPrimaryZone();
        result = result * 59 + ($primaryZone == null ? 43 : $primaryZone.hashCode());
        String $binding = this.getBinding();
        result = result * 59 + ($binding == null ? 43 : $binding.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        TableGroupPartition $tableGroupPartition = this.getTableGroupPartition();
        result = result * 59 + ($tableGroupPartition == null ? 43 : ((Object)$tableGroupPartition).hashCode());
        return result;
    }

    public long getTableGroupId() {
        return this.tableGroupId;
    }

    public void setTableGroupId(long tableGroupId) {
        this.tableGroupId = tableGroupId;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    public int getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(int partLevel) {
        this.partLevel = partLevel;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getIsSubPartTemplate() {
        return this.isSubPartTemplate;
    }

    public void setIsSubPartTemplate(int isSubPartTemplate) {
        this.isSubPartTemplate = isSubPartTemplate;
    }

    public TableGroupPartition getTableGroupPartition() {
        return this.tableGroupPartition;
    }

    public void setTableGroupPartition(TableGroupPartition tableGroupPartition) {
        this.tableGroupPartition = tableGroupPartition;
    }
}

