/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class ObMySqlUniqueKey
extends AbstractObMySqlConstraint {
    private String locality;

    public ObMySqlUniqueKey(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return super.getSchema();
    }

    @Override
    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("unique key").append((CharSequence)this.joinConstraintColumns());
        String indexType = this.getIndexType();
        if ("GLOBAL".equals(indexType) || "GLOBAL UNIQUE".equals(indexType)) {
            this.setLocality("GLOBAL");
        } else if ("LOCAL".equals(indexType) || "LOCAL UNIQUE".equals(indexType)) {
            this.setLocality("LOCAL");
        }
        return StringUtils.isBlank(this.getLocality()) ? sb : sb.append(" ").append(this.getLocality());
    }

    @Override
    public String toString() {
        return "ObMySqlUniqueKey(locality=" + this.getLocality() + ")";
    }

    public ObMySqlUniqueKey() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlUniqueKey)) {
            return false;
        }
        ObMySqlUniqueKey other = (ObMySqlUniqueKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        return !(this$locality == null ? other$locality != null : !this$locality.equals(other$locality));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlUniqueKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        return result;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }
}

