/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.strategy;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.TreeMap;

public class AdaptiveBatchStrategy {
    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final long MAX_BATCH_BYTE_SIZE = 0x200000L;
    static final TreeMap<Integer, Integer> ADAPTIVE_TREE_MAP = new TreeMap<Integer, Integer>(){
        {
            int i;
            this.put(0, 1);
            for (i = 1; i < 10; ++i) {
                this.put(i, i);
            }
            i = 100;
            int j = 1;
            while (i <= 2000) {
                this.put(i, i);
                i = j * 100;
                ++j;
            }
        }
    };
    private final long maxBatchByteSize;
    private final LoadingCache<Pair<String, Long>, Integer> consistencyCache;

    public AdaptiveBatchStrategy() {
        this(0x200000L);
    }

    public AdaptiveBatchStrategy(long maxBatchByteSize) {
        this.maxBatchByteSize = maxBatchByteSize;
        this.consistencyCache = this.createConsistencyCache();
    }

    private LoadingCache<Pair<String, Long>, Integer> createConsistencyCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(1).recordStats().build((CacheLoader)new CacheLoader<Pair<String, Long>, Integer>(){

            public synchronized Integer load(Pair<String, Long> key) {
                long firstRowSize = key.getRight();
                int realBatchSize = (int)(AdaptiveBatchStrategy.this.maxBatchByteSize / firstRowSize);
                Map.Entry<Integer, Integer> entry = ADAPTIVE_TREE_MAP.floorEntry(realBatchSize);
                return entry == null ? null : entry.getValue();
            }
        });
    }

    @Deprecated
    public int getBatchSize(String tableName, long firstRowSize) {
        return this.getBatchSize(tableName, firstRowSize, 200);
    }

    public int getBatchSize(String tableName, long firstRowSize, int defaultBatch) {
        if (defaultBatch > 0) {
            return defaultBatch;
        }
        try {
            Integer batchSize = (Integer)this.consistencyCache.get(new Pair<String, Long>(tableName, firstRowSize));
            return batchSize == null ? defaultBatch : batchSize;
        }
        catch (Exception e) {
            return defaultBatch;
        }
    }

    static class Pair<L, R> {
        private L left;
        private R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equal(this.left, pair.left);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.left});
        }
    }
}

