/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWriter
extends AbstractRollingFileWriter {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileWriter.class);
    private String fileEncoding;
    private BufferedWriter writer;

    public DefaultFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding) {
        this(Integer.MAX_VALUE, filePath, fileName, fileSuffix, fileEncoding);
    }

    public DefaultFileWriter(int groupNo, String filePath, String fileName, String fileSuffix, String fileEncoding) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.fileEncoding = fileEncoding;
    }

    @Override
    public long write(Object line) throws Exception {
        String raw = line.toString();
        this.writer.write(raw);
        return raw.getBytes(this.fileEncoding).length;
    }

    @Override
    public void attemptCloseResource() {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                log.warn("Flush failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
            finally {
                try {
                    this.writer.close();
                    this.closed = true;
                }
                catch (IOException e) {
                    log.warn("Close failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                }
                this.writer = null;
            }
        }
    }

    @Override
    public DefaultFileWriter current() throws Exception {
        return this.current(Integer.getInteger("fs.page", 0x100000));
    }

    @Override
    public DefaultFileWriter current(int bufferSize) throws Exception {
        String activeFilePath = this.createNewFile();
        this.closed = false;
        this.activeFile = activeFilePath;
        FileOutputStream fos = new FileOutputStream(activeFilePath);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.fileEncoding), bufferSize);
        return this;
    }
}

