/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileWriter
extends AbstractRollingFileWriter
implements Flushable {
    private static final Logger log = LoggerFactory.getLogger(OrcFileWriter.class);
    private AtomicBoolean state;
    private Configuration conf;
    private TypeDescription schema;
    private Writer writer;
    private VectorizedRowBatch batch;

    private OrcFileWriter(Configuration conf, TypeDescription schema, Writer writer, String initFile, int groupNo, String filePath, String fileName, String fileSuffix) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.conf = conf;
        this.writer = writer;
        this.schema = schema;
        this.activeFile = initFile;
        this.batch = writer.getSchema().createRowBatchV2();
        this.state = new AtomicBoolean(true);
    }

    @Override
    public long write(Object row) throws Exception {
        return this.write((String[])row, "UTF-8");
    }

    public long write(String[] row, String charset) throws Exception {
        int size = this.batch.size++;
        long byteSize = 0L;
        for (int i = 0; i < row.length; ++i) {
            byte[] bytes = this.getBytes(row[i], charset);
            ((BytesColumnVector)this.batch.cols[i]).setVal(size, bytes);
            byteSize += (long)bytes.length;
        }
        if (this.batch.size == this.batch.getMaxSize()) {
            this.flush();
        }
        return byteSize;
    }

    @Override
    public void flush() throws IOException {
        this.writer.addRowBatch(this.batch);
        this.batch.reset();
    }

    @Override
    public void attemptCloseResource() {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            try {
                this.flush();
            }
            catch (IOException e) {
                log.warn("Flush failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
            finally {
                try {
                    this.writer.close();
                    this.closed = true;
                }
                catch (IOException e) {
                    log.warn("Close failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                }
                this.writer = null;
            }
        }
    }

    @Override
    public OrcFileWriter current() throws Exception {
        return this.current(0x10000000);
    }

    @Override
    public OrcFileWriter current(int bufferSize) throws Exception {
        if (this.state.compareAndSet(true, false)) {
            return this;
        }
        String activeFilePath = this.createNewFile();
        this.closed = false;
        this.activeFile = activeFilePath;
        Configuration conf = this.conf;
        TypeDescription schema = this.schema;
        this.writer = OrcFileWriter.createOrcWriter(schema, conf, new Path(activeFilePath));
        return this;
    }

    static Writer createOrcWriter(TypeDescription schema, Configuration conf, Path of) throws Exception {
        return OrcFile.createWriter((Path)of, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(schema).overwrite(true).stripeSize(0x100000L).enforceBufferSize().encodingStrategy(OrcFile.EncodingStrategy.SPEED).compress(CompressionKind.ZSTD).version(OrcFile.Version.V_0_12));
    }

    public static class Builder {
        private String initFile;
        private int groupNo;
        private String filePath;
        private String fileName;
        private String fileSuffix = DataFormat.ORC.getDefaultFileSuffix();
        private Configuration conf = new Configuration();
        private TypeDescription schema;

        public Builder withInitFile(String initFile) {
            this.initFile = initFile;
            return this;
        }

        public Builder withGroupNo(int groupNo) {
            this.groupNo = groupNo;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withColumnNames(List<String> columnNames) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)"Column names is null");
            this.schema = TypeDescription.createStruct();
            for (String columnName : columnNames) {
                this.schema.addField(columnName, Builder.getMappedTypeDescription(null));
            }
            return this;
        }

        static TypeDescription getMappedTypeDescription(String dataType) {
            return TypeDescription.createString();
        }

        public OrcFileWriter build() throws Exception {
            Preconditions.checkArgument((this.initFile != null ? 1 : 0) != 0, (Object)"init file is null");
            Configuration conf = this.conf;
            TypeDescription schema = this.schema;
            Writer writer = OrcFileWriter.createOrcWriter(schema, conf, new Path(this.initFile));
            return new OrcFileWriter(conf, schema, writer, this.initFile, this.groupNo, this.filePath, this.fileName, this.fileSuffix);
        }
    }
}

