/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileWriterV2
extends AbstractRollingFileWriter
implements Flushable {
    private static final Logger log = LoggerFactory.getLogger(OrcFileWriterV2.class);
    private final AtomicBoolean state;
    private Writer orcWriter;
    private final Configuration conf;
    private final TypeDescription schema;
    private VectorizedRowBatch batch;
    private ColumnValueSetter[] columnValueSetters;

    public OrcFileWriterV2(int groupNo, String filePath, String fileName, String fileSuffix, Configuration conf, Writer orcWriter, TypeDescription schema, String initFile) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.conf = conf;
        this.orcWriter = orcWriter;
        this.activeFile = initFile;
        this.schema = schema;
        this.initColumnValueSetters(schema);
        this.batch = orcWriter.getSchema().createRowBatchV2();
        this.state = new AtomicBoolean(true);
    }

    @Override
    public long write(Object row) throws Exception {
        String[] rowValues = (String[])row;
        int rowIdx = this.batch.size++;
        long byteSize = 0L;
        for (int i = 0; i < this.columnValueSetters.length; ++i) {
            String value = rowValues[i];
            ColumnVector vec = this.batch.cols[i];
            if (value == null) {
                vec.isNull[rowIdx] = true;
                vec.noNulls = false;
                continue;
            }
            this.columnValueSetters[i].setValue(this.batch.cols[i], rowIdx, rowValues[i]);
            byteSize += (long)value.length();
        }
        if (this.batch.size == this.batch.getMaxSize()) {
            this.flush();
        }
        return byteSize;
    }

    @Override
    public void attemptCloseResource() {
        if (this.closed) {
            return;
        }
        if (this.orcWriter != null) {
            try {
                this.flush();
            }
            catch (IOException e) {
                log.warn("Flush failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
            finally {
                try {
                    this.orcWriter.close();
                    this.closed = true;
                }
                catch (Exception e) {
                    log.error("Close failed. Error: ", (Throwable)e);
                }
                this.orcWriter = null;
            }
        }
    }

    @Override
    public AbstractRollingFileWriter current() throws Exception {
        return this.current(0x10000000);
    }

    @Override
    public AbstractRollingFileWriter current(int bufferSize) throws Exception {
        if (this.state.compareAndSet(true, false)) {
            return this;
        }
        String activeFilePath = this.createNewFile();
        this.closed = false;
        this.activeFile = activeFilePath;
        Configuration conf = this.conf;
        TypeDescription schema = this.schema;
        this.orcWriter = OrcFileWriterV2.createOrcWriterV2(schema, conf, new Path(activeFilePath));
        this.batch = this.orcWriter.getSchema().createRowBatchV2();
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.orcWriter.addRowBatch(this.batch);
        this.batch.reset();
    }

    private void initColumnValueSetters(TypeDescription schema) {
        int colNum = schema.getChildren().size();
        this.columnValueSetters = new ColumnValueSetter[colNum];
        block6: for (int i = 0; i < colNum; ++i) {
            TypeDescription type = (TypeDescription)schema.getChildren().get(i);
            switch (type.getCategory()) {
                case LONG: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((LongColumnVector)vec).vector[rowIdx] = Long.parseLong(value);
                    };
                    continue block6;
                }
                case DOUBLE: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((DoubleColumnVector)vec).vector[rowIdx] = Double.parseDouble(value);
                    };
                    continue block6;
                }
                case DECIMAL: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> ((DecimalColumnVector)vec).set(rowIdx, HiveDecimal.create((String)value));
                    continue block6;
                }
                case BOOLEAN: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((LongColumnVector)vec).vector[rowIdx] = Boolean.parseBoolean(value) ? 1L : 0L;
                    };
                    continue block6;
                }
                default: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> ((BytesColumnVector)vec).setVal(rowIdx, this.getBytes(value, "UTF-8"));
                }
            }
        }
    }

    static Writer createOrcWriterV2(TypeDescription schema, Configuration conf, Path of) throws Exception {
        conf.setDouble(OrcConf.MEMORY_POOL.getAttribute(), 0.5);
        conf.set(OrcConf.COMPRESSION_STRATEGY.getAttribute(), OrcFile.CompressionStrategy.COMPRESSION.name());
        conf.setInt(OrcConf.ROW_BATCH_SIZE.getAttribute(), 2048);
        conf.set(OrcConf.DICTIONARY_IMPL.getAttribute(), "hash");
        return OrcFile.createWriter((Path)of, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(schema).overwrite(true).bufferSize(262144).stripeSize(0x4000000L).blockSize(0x20000000L).encodingStrategy(OrcFile.EncodingStrategy.SPEED).compress(CompressionKind.ZSTD).version(OrcFile.Version.V_0_12));
    }

    public static class Builder {
        private String initFile;
        private int groupNo;
        private String filePath;
        private String fileName;
        private String fileSuffix = DataFormat.ORC.getDefaultFileSuffix();
        private Configuration conf = new Configuration();
        private Map<String, Object> columnTypeMap;

        public Builder withInitFile(String initFile) {
            this.initFile = initFile;
            return this;
        }

        public Builder withGroupNo(int groupNo) {
            this.groupNo = groupNo;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withColumnTypeMap(Map<String, Object> columnTypeMap) {
            this.columnTypeMap = columnTypeMap;
            return this;
        }

        static TypeDescription assembleTypeDescription(Object dataTypeObj) {
            String dataType = dataTypeObj.toString();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "bool": 
                case "boolean": {
                    return TypeDescription.createBoolean();
                }
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": 
                case "bigint": {
                    return TypeDescription.createLong();
                }
                case "float": 
                case "double": {
                    return TypeDescription.createDouble();
                }
                case "number": 
                case "numeric": 
                case "real": 
                case "decimal": 
                case "bigdecimal": 
                case "binary_float": 
                case "binary_double": {
                    return TypeDescription.createDecimal();
                }
                case "bit": 
                case "raw": 
                case "longraw": 
                case "binary": 
                case "varbinary": 
                case "longvarbinary": 
                case "tinyblob": 
                case "blob": 
                case "mediumblob": 
                case "clob": 
                case "nclob": 
                case "longblob": {
                    return TypeDescription.createBinary();
                }
            }
            return TypeDescription.createString();
        }

        public OrcFileWriterV2 build() throws Exception {
            TypeDescription schema = TypeDescription.createStruct();
            this.columnTypeMap.forEach((columnName, columnType) -> schema.addField(columnName, Builder.assembleTypeDescription(columnType)));
            Writer writer = OrcFileWriterV2.createOrcWriterV2(schema, this.conf, new Path(this.initFile));
            return new OrcFileWriterV2(this.groupNo, this.filePath, this.fileName, this.fileSuffix, this.conf, writer, schema, this.initFile);
        }
    }

    static interface ColumnValueSetter {
        public void setValue(ColumnVector var1, int var2, String var3) throws Exception;
    }
}

