/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriter
extends AbstractRollingFileWriter {
    private static final Logger log = LoggerFactory.getLogger(ParquetFileWriter.class);
    private AtomicBoolean state;
    private Configuration conf;
    private MessageType schema;
    private ParquetWriter<Group> writer;
    static Constructor<ParquetWriter> constructor;

    private ParquetFileWriter(Configuration conf, MessageType schema, ParquetWriter<Group> writer, String initFile, int groupNo, String filePath, String fileName, String fileSuffix) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.conf = conf;
        this.writer = writer;
        this.schema = schema;
        this.activeFile = initFile;
        this.state = new AtomicBoolean(true);
    }

    @Override
    public long write(Object row) throws Exception {
        return this.write((String[])row, "UTF-8");
    }

    public long write(String[] row, String charset) throws Exception {
        long byteSize = 0L;
        SimpleGroup group = new SimpleGroup((GroupType)this.schema);
        for (int i = 0; i < row.length; ++i) {
            String data = row[i] == null ? Constants.CsvConsts.ASCII_NULL_STRING : row[i];
            group.add(i, data);
            byteSize += (long)this.getBytes(data, charset).length;
        }
        this.writer.write((Object)group);
        return byteSize;
    }

    @Override
    public void attemptCloseResource() {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
                this.closed = true;
            }
            catch (IOException e) {
                log.warn("Close failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
            this.writer = null;
        }
    }

    @Override
    public ParquetFileWriter current() throws Exception {
        return this.current(0x10000000);
    }

    @Override
    public ParquetFileWriter current(int bufferSize) throws Exception {
        if (this.state.compareAndSet(true, false)) {
            return this;
        }
        String activeFilePath = this.createNewFile();
        this.closed = false;
        this.activeFile = activeFilePath;
        MessageType schema = this.schema;
        Configuration conf = this.conf;
        this.writer = ParquetFileWriter.createParquetWriter(schema, conf, new Path(activeFilePath));
        return this;
    }

    static ParquetWriter<Group> createParquetWriter(MessageType schema, Configuration conf, Path path) throws Exception {
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        ParquetProperties encodingProps = ParquetProperties.builder().withBloomFilterEnabled(false).estimateRowCountForPageSizeCheck(true).withMinRowCountForPageSizeCheck(100).withMaxRowCountForPageSizeCheck(10000).withPageRowCountLimit(20000).withPageSize(0x100000).withPageWriteChecksumEnabled(true).withByteStreamSplitEncoding(true).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withDictionaryEncoding(true).withDictionaryPageSize(0x100000).build();
        return ParquetFileWriter.newParquetWriterInstance((OutputFile)HadoopOutputFile.fromPath((Path)path, (Configuration)conf), ParquetFileWriter.Mode.OVERWRITE, new GroupWriteSupport(), CompressionCodecName.ZSTD, 0x800000L, false, conf, 0, encodingProps, null);
    }

    static synchronized ParquetWriter<Group> newParquetWriterInstance(OutputFile file, ParquetFileWriter.Mode mode, GroupWriteSupport writeSupport, CompressionCodecName compressionCodecName, long rowGroupSize, boolean validating, Configuration conf, int maxPaddingSize, ParquetProperties encodingProps, FileEncryptionProperties encryptionProps) {
        try {
            if (constructor == null) {
                constructor = ParquetWriter.class.getDeclaredConstructor(OutputFile.class, ParquetFileWriter.Mode.class, WriteSupport.class, CompressionCodecName.class, Long.TYPE, Boolean.TYPE, Configuration.class, Integer.TYPE, ParquetProperties.class, FileEncryptionProperties.class);
                constructor.setAccessible(true);
            }
            return constructor.newInstance(file, mode, writeSupport, compressionCodecName, rowGroupSize, validating, conf, maxPaddingSize, encodingProps, encryptionProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parquet writer constructor failed", e);
        }
    }

    public static class Builder {
        private MessageType schema;
        private String initFile;
        private int groupNo;
        private String filePath;
        private String fileName;
        private String fileSuffix = DataFormat.PAR.getDefaultFileSuffix();
        private Configuration conf = new Configuration();

        public Builder withInitFile(String initFile) {
            this.initFile = initFile;
            return this;
        }

        public Builder withGroupNo(int groupNo) {
            this.groupNo = groupNo;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withColumnNames(String schemaName, List<String> columnNames) {
            Types.MessageTypeBuilder mtb = Types.buildMessage();
            for (String columnName : columnNames) {
                Pair<PrimitiveType.PrimitiveTypeName, LogicalTypeAnnotation> pair = Builder.getMappedPrimitiveType(null);
                ((Types.PrimitiveBuilder)mtb.required(pair.getLeft()).as(pair.getRight())).named(columnName);
            }
            this.schema = mtb.named(schemaName);
            return this;
        }

        static Pair<PrimitiveType.PrimitiveTypeName, LogicalTypeAnnotation> getMappedPrimitiveType(String dataType) {
            return new Pair<PrimitiveType.PrimitiveTypeName, LogicalTypeAnnotation.StringLogicalTypeAnnotation>(PrimitiveType.PrimitiveTypeName.BINARY, LogicalTypeAnnotation.stringType());
        }

        public ParquetFileWriter build() throws Exception {
            Preconditions.checkArgument((this.initFile != null ? 1 : 0) != 0, (Object)"init file is null");
            MessageType schema = this.schema;
            Configuration conf = this.conf;
            ParquetWriter<Group> writer = ParquetFileWriter.createParquetWriter(schema, conf, new Path(this.initFile));
            return new ParquetFileWriter(conf, schema, writer, this.initFile, this.groupNo, this.filePath, this.fileName, this.fileSuffix);
        }
    }
}

