/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriterV2
extends AbstractRollingFileWriter {
    private static final Logger log = LoggerFactory.getLogger(ParquetFileWriterV2.class);
    private final AtomicBoolean state;
    private final Configuration conf;
    private final MessageType schema;
    private ParquetWriter<Group> writer;
    private ColumnValueSetter[] columnValueSetters;

    public ParquetFileWriterV2(Configuration conf, MessageType schema, ParquetWriter<Group> writer, String initFile, int groupNo, String filePath, String fileName, String fileSuffix) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.writer = writer;
        this.activeFile = initFile;
        this.schema = schema;
        this.initColumnValueSetters(schema);
        this.conf = conf;
        this.state = new AtomicBoolean(true);
    }

    @Override
    public long write(Object row) throws Exception {
        long byteSize = 0L;
        SimpleGroup group = new SimpleGroup((GroupType)this.schema);
        for (int i = 0; i < this.columnValueSetters.length; ++i) {
            String value = ((String[])row)[i];
            if (value == null) continue;
            this.columnValueSetters[i].setValue((Group)group, i, value);
            byteSize += (long)value.length();
        }
        this.writer.write((Object)group);
        return byteSize;
    }

    @Override
    public void attemptCloseResource() {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
                this.closed = true;
            }
            catch (Exception e) {
                log.error("Close failed. Error: ", (Throwable)e);
            }
        }
    }

    @Override
    public ParquetFileWriterV2 current() throws Exception {
        return this.current(0x10000000);
    }

    @Override
    public ParquetFileWriterV2 current(int bufferSize) throws Exception {
        if (this.state.compareAndSet(true, false)) {
            return this;
        }
        String activeFilePath = this.createNewFile();
        this.closed = false;
        this.activeFile = activeFilePath;
        MessageType schema = this.schema;
        Configuration conf = this.conf;
        this.writer = ParquetFileWriterV2.createParquetWriter(schema, conf, new Path(activeFilePath));
        return this;
    }

    private void initColumnValueSetters(MessageType schema) {
        int colNum = schema.getFields().size();
        this.columnValueSetters = new ColumnValueSetter[colNum];
        block6: for (int i = 0; i < colNum; ++i) {
            Type type = (Type)schema.getFields().get(i);
            switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Integer.parseInt(value));
                    continue block6;
                }
                case INT64: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Long.parseLong(value));
                    continue block6;
                }
                case BOOLEAN: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Boolean.parseBoolean(value));
                    continue block6;
                }
                case DOUBLE: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Double.parseDouble(value));
                    continue block6;
                }
                default: {
                    this.columnValueSetters[i] = Group::add;
                }
            }
        }
    }

    static ParquetWriter<Group> createParquetWriter(MessageType schema, Configuration conf, Path path) throws Exception {
        return ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withType(schema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).withBloomFilterEnabled(false)).withConf(conf)).withCompressionCodec(CompressionCodecName.ZSTD)).withDictionaryEncoding(true)).withPageWriteChecksumEnabled(false)).build();
    }

    public static class Builder {
        private MessageType schema;
        private String initFile;
        private int groupNo;
        private String filePath;
        private String fileName;
        private String fileSuffix = DataFormat.PAR.getDefaultFileSuffix();
        private Configuration conf = new Configuration();

        public Builder withInitFile(String initFile) {
            this.initFile = initFile;
            return this;
        }

        public Builder withGroupNo(int groupNo) {
            this.groupNo = groupNo;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withColumnTypeMap(String schemaName, Map<String, Object> colTypeMap) {
            Types.MessageTypeBuilder mtb = Types.buildMessage();
            colTypeMap.forEach((columnName, columnType) -> {
                Types.GroupBuilder cfr_ignored_0 = (Types.GroupBuilder)mtb.addField(Builder.getMappedPrimitiveType(columnName, columnType));
            });
            this.schema = mtb.named(schemaName);
            return this;
        }

        static Type getMappedPrimitiveType(String columnName, Object columnType) {
            String dataType = columnType.toString();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named(columnName);
                }
                case "bigint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(columnName);
                }
                case "float": 
                case "double": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName);
                }
                case "number": 
                case "numeric": 
                case "real": 
                case "decimal": 
                case "bigdecimal": 
                case "binary_float": 
                case "binary_double": {
                    return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)9, (int)38))).named(columnName);
                }
                case "bit": 
                case "raw": 
                case "longraw": 
                case "binary": 
                case "varbinary": 
                case "longvarbinary": 
                case "tinyblob": 
                case "blob": 
                case "mediumblob": 
                case "clob": 
                case "nclob": 
                case "longblob": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named(columnName);
                }
                case "bool": 
                case "boolean": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(columnName);
                }
            }
            return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName);
        }

        public ParquetFileWriterV2 build() throws Exception {
            Preconditions.checkArgument((this.initFile != null ? 1 : 0) != 0, (Object)"init file is null");
            MessageType schema = this.schema;
            Configuration conf = this.conf;
            ParquetWriter<Group> writer = ParquetFileWriterV2.createParquetWriter(schema, conf, new Path(this.initFile));
            return new ParquetFileWriterV2(conf, schema, writer, this.initFile, this.groupNo, this.filePath, this.fileName, this.fileSuffix);
        }
    }

    static interface ColumnValueSetter {
        public void setValue(Group var1, int var2, String var3) throws Exception;
    }
}

