/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Manifest;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.loader.record.RecordFileLoader;
import com.oceanbase.tools.loaddump.loader.schema.SchemaFileLoader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import java.io.File;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.ThreadContext;

public class LoadClient {
    protected State state;
    protected final LoadParameter parameter;

    protected LoadClient(LoadParameter parameter) {
        this.parameter = parameter;
        this.rectifyFilePath();
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    protected LoadClient init() throws Exception {
        ConnectionKey connectionKey = this.parameter.buildConnectionKey();
        Database database = new Database(this.parameter.getDatabaseName());
        database.setServerMode(connectionKey.getServerMode());
        database.setSubsequentV4(connectionKey.getServerMode().isSubsequent("4.0.0.0"));
        this.parameter.setDatabase(database);
        if (!connectionKey.getServerMode().isPrevious("3.2.4.0")) {
            int openCursors = connectionKey.getMetadataProvider().queryOpenCursors();
            Preconditions.checkState((this.parameter.getThreads() <= openCursors ? 1 : 0) != 0, (String)"The system config open_cursors value(%s) may be not enough. Please alter system set open_cursors=1000 or larger value than 1000 manually.", (int)openCursors);
        }
        if (connectionKey.getServerMode().isPrevious("4.1.0.0")) {
            Preconditions.checkState((!this.parameter.isDirectMode() ? 1 : 0) != 0, (Object)"The direct load feature is only supported by OceanBase 4.1.0.0-bp4 and later.");
        }
        ServerMode serverMode = connectionKey.getServerMode();
        if (this.parameter.isEnableHiddenPk()) {
            Preconditions.checkState((boolean)serverMode.isPreviousV4(), (Object)"Option --enable-hidden-pk is unsupported for OceanBase v4.0+.");
            if (serverMode.isMysqlMode() && !connectionKey.getUsername().equals("__oceanbase_inner_drc_user")) {
                throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__oceanbase_inner_drc_user\"");
            }
            if (serverMode.isOracleMode() && !connectionKey.getUsername().equals("__OCEANBASE_INNER_DRC_USER")) {
                throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__OCEANBASE_INNER_DRC_USER\"");
            }
        }
        if (this.parameter.getDataFormat() == DataFormat.CSV) {
            Manifest manifest = new Manifest(this.parameter);
            if (!this.parameter.isExternal() || this.parameter.isRetry()) {
                Preconditions.checkState((boolean)manifest.exists(), (String)"Manifest: \"%s\" is missing. You can use \"--external-data\" to skip this check.", (Object)manifest.toPath());
                manifest.replaceTo(this.parameter);
            }
            SerializeUtils.serializeObjectByKryo(manifest, manifest.toPath());
            LogUtils.info("Manifest: \"{}\" has been saved", manifest.toPath());
        }
        this.state = State.INITIAL;
        return this;
    }

    private void rectifyFilePath() {
        File f = new File(this.parameter.getFilePath());
        if (f.isFile()) {
            FileUtils.checkValidFile(f);
        } else {
            FileUtils.checkValidDirectory(f);
        }
        if (f.isFile()) {
            this.parameter.setInputFile(f);
            this.parameter.setFilePath(f.getParent());
            this.parameter.getWhiteListMap().put(ObjectType.FILE, Sets.newHashSet((Object[])new String[]{f.getName()}));
        } else {
            this.parameter.setFilePath(f.getAbsolutePath());
        }
        Set<String> tableSet = this.parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.MIX || this.parameter.getInputFile() == null || tableSet == null || tableSet.size() == 1 ? 1 : 0) != 0, (Object)"One table can only correspond to one data file");
    }

    public TaskContext loadSchema() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((this.parameter.isIncludeDdl() || DataFormat.MIX == this.parameter.getDataFormat() ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendSchemaOption());
        return new SchemaFileLoader(this.parameter).prepare().loadSchemaAsync();
    }

    public TaskContext loadRecord() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        DataFormat dataFormat = this.parameter.getDataFormat();
        Preconditions.checkArgument((dataFormat != null && dataFormat != DataFormat.DDL && dataFormat != DataFormat.MIX ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        ConnectionKey connectionKey = this.parameter.buildConnectionKey();
        AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
        Database database = connectionKey.getMetadataProvider().queryDatabase(connectionKey, advancedOption);
        this.parameter.setDatabase(database);
        this.parameter.setDatabaseName(database.getSchemaName());
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(database.getTableInfoMap()), (String)"The base tables (non temporary) are not found in the schema: %s. Please check the --table option!", (Object)database.getSchemaName());
        return new RecordFileLoader(this.parameter).prepare().loadRecordAsync();
    }

    public static class Builder {
        private final LoadParameter parameter;

        public Builder(LoadParameter parameter) {
            this.parameter = parameter;
        }

        public LoadClient build() throws Exception {
            return new LoadClient(this.parameter).init();
        }
    }
}

