/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.alibaba.druid.pool.DruidPooledStatement;
import com.google.common.base.Preconditions;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.manager.session.SessionManager;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDumpClient {
    private static final Logger log = LoggerFactory.getLogger(RemoteDumpClient.class);
    protected State state;
    protected final DumpParameter parameter;
    protected List<String> tables;
    private static final String REMOTE_DUMP_SQL = "select {0} * into outfile {1} FIELDS TERMINATED BY {2} OPTIONALLY ENCLOSED BY {3} LINES TERMINATED BY {4} from {5}";

    protected RemoteDumpClient(DumpParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    protected RemoteDumpClient init() throws Exception {
        Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.CSV ? 1 : 0) != 0, (Object)"Remote dump only allows --csv");
        ConnectionKey connectionKey = this.parameter.buildConnectionKey();
        AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
        this.tables = connectionKey.getMetadataProvider().queryTables(connectionKey, advancedOption).stream().map(TableInfo::getTable).collect(Collectors.toList());
        return this;
    }

    public int dumpRecords() {
        boolean isFile;
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        SessionManager sessionManager = connectionKey.getSessionManager();
        String path = this.parameter.getFilePath();
        boolean bl = isFile = path.endsWith(".csv") || path.endsWith(".txt") || path.endsWith(".dat");
        if (isFile && this.tables.size() != 1) {
            throw new IllegalArgumentException("File name does not match the table count");
        }
        int parallel = this.parameter.getParallel();
        String parallelHint = parallel > 0 ? "/*+parallel(" + this.parameter.getParallel() + ")*/" : "";
        ExecutorTemplate<TaskDetail> template = new ExecutorTemplate<TaskDetail>("remote-dump-", this.parameter.getThreads());
        for (String table : this.tables) {
            String realFilePath = isFile ? path : FileUtils.toPath(path, table + ".csv");
            String sql = MessageFormat.format(REMOTE_DUMP_SQL, parallelHint, StringUtils.wrapWithQuot(realFilePath), StringUtils.wrapWithQuot(this.parameter.getColumnSeparator()), StringUtils.wrapWithQuot(this.parameter.getColumnDelimiter()), StringUtils.wrapWithQuot(StringEscapeUtils.escapeJava((String)this.parameter.getLineSeparator())), table);
            template.submit(() -> {
                TaskDetail taskDetail = new TaskDetail();
                taskDetail.setSchema(connectionKey.getDatabase());
                taskDetail.setObject(table);
                taskDetail.setType(ObjectType.TABLE.getName());
                try (Connection conn = sessionManager.getPooledBizConnection();){
                    DruidPooledStatement stmt = (DruidPooledStatement)conn.createStatement();
                    OceanBaseStatement stmt1 = (OceanBaseStatement)stmt.getStatement();
                    log.info("Execute SQL: {}", (Object)sql);
                    long affected = stmt1.executeLargeUpdate(sql);
                    taskDetail.setCount(affected);
                    taskDetail.setState(TaskState.SUCCESS);
                }
                catch (Exception e) {
                    taskDetail.setState(TaskState.FAILURE);
                    taskDetail.setError(ExceptionUtils.getRootCauseMessage(e));
                    log.error("Dump [{}] failed!", (Object)table, (Object)e);
                }
                return taskDetail;
            });
        }
        List<TaskDetail> detailList = template.waitForResult();
        Summary summary = new Summary("All Remote Dump Tasks Finished", detailList);
        log.info(summary.toHumanReadableFormat());
        return detailList.stream().allMatch(TaskDetail::isSuccess) ? 0 : 1;
    }

    public static class Builder {
        private final DumpParameter parameter;

        public Builder(DumpParameter parameter) {
            this.parameter = parameter;
        }

        public RemoteDumpClient build() throws Exception {
            return new RemoteDumpClient(this.parameter).init();
        }
    }
}

