/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.dumper.uploader.BatchFileUploader;
import com.oceanbase.tools.loaddump.factory.FileUploaderFactory;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DumpPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DumpPostProcessor.class);
    public static final DumpPostProcessor INSTANCE = new DumpPostProcessor();

    private DumpPostProcessor() {
    }

    public void moveSchemaFiles(DumpParameter parameter) {
        String outputFilePath = parameter.getOutputFile();
        if (outputFilePath == null) {
            return;
        }
        if (com.oceanbase.tools.loaddump.utils.FileUtils.isValidDirPath(outputFilePath) && outputFilePath.equals(parameter.getDefaultTableDataPath())) {
            return;
        }
        File dataDir = new File(parameter.getDefaultDatabasePath());
        Collection schemaFiles = FileUtils.listFiles((File)dataDir, (String[])new String[]{DataFormat.DDL.getDefaultExtension()}, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)schemaFiles)) {
            log.info("No schema files are found in the path: \"{}\"", (Object)dataDir);
            return;
        }
        if (com.oceanbase.tools.loaddump.utils.FileUtils.isValidFilePath(outputFilePath)) {
            File schemaFile = (File)CollectionUtils.get((Object)schemaFiles, (int)0);
            try {
                FileUtils.moveFile((File)schemaFile, (File)new File(outputFilePath));
            }
            catch (IOException e) {
                log.error("Move \"{}\" to path: \"{}\" failed. Error: {}", new Object[]{schemaFile, outputFilePath, ExceptionUtils.getRootCauseMessage(e)});
            }
        } else {
            for (File schemaFile : schemaFiles) {
                String schemaFileName = schemaFile.getName();
                if (!schemaFileName.endsWith("-schema.sql")) continue;
                ObjectType objectType = ObjectType.valueOfName(schemaFile.getParentFile().getName());
                String objectName = schemaFileName.substring(0, schemaFileName.length() - "-schema.sql".length());
                Set objectSet = parameter.getWhiteListMap().getOrDefault((Object)objectType, new HashSet());
                try {
                    if (!CollectionUtils.isEmpty((Collection)objectSet) && !objectSet.contains(DBUtils.extractObjectName(objectName, null))) continue;
                    FileUtils.moveFileToDirectory((File)schemaFile, (File)new File(outputFilePath), (boolean)true);
                    log.info("Move \"{}\" to path: \"{}\" success.", (Object)schemaFile, (Object)outputFilePath);
                }
                catch (IOException e) {
                    log.error("Move \"{}\" to path: \"{}\" failed. Error: {}", new Object[]{schemaFile, outputFilePath, ExceptionUtils.getRootCauseMessage(e)});
                }
            }
        }
        com.oceanbase.tools.loaddump.utils.FileUtils.deleteQuietly((File)new File(com.oceanbase.tools.loaddump.utils.FileUtils.toPath(parameter.getDataPath(), "MANIFEST.bin")));
        com.oceanbase.tools.loaddump.utils.FileUtils.deleteQuietly((File)new File(parameter.getCheckpointPath()));
    }

    public void mergeRecordFiles(DumpParameter parameter) {
        String outputFilePath = parameter.getOutputFile();
        if (outputFilePath == null) {
            return;
        }
        boolean isDir = com.oceanbase.tools.loaddump.utils.FileUtils.isValidDirPath(outputFilePath);
        String tempFilePath = isDir ? outputFilePath : StringUtils.substringBeforeLast(outputFilePath, File.separator);
        String tempFileName = isDir ? " " : StringUtils.substringAfterLast(outputFilePath, File.separator);
        Set tableSet = parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
        Map<String, List<File>> fileGroup = com.oceanbase.tools.loaddump.utils.FileUtils.groupByName(tableSet, parameter.getDataPath(), parameter.getFileSuffix());
        if (MapUtils.isEmpty(fileGroup)) {
            return;
        }
        com.oceanbase.tools.loaddump.utils.FileUtils.mergeFiles(fileGroup, tempFilePath, tempFileName, parameter.getFileSuffix(), parameter.getDataFormat());
        com.oceanbase.tools.loaddump.utils.FileUtils.deleteQuietly((File)new File(com.oceanbase.tools.loaddump.utils.FileUtils.toPath(parameter.getDataPath(), "MANIFEST.bin")));
        com.oceanbase.tools.loaddump.utils.FileUtils.deleteQuietly((File)new File(parameter.getCheckpointPath()));
    }

    public void uploadSchemaFiles(DumpParameter parameter) throws Exception {
        if (parameter.getStorageConfig() == null || parameter.getUploadBehavior() != UploadBehavior.COMPLETE || !parameter.isIncludeDdl()) {
            return;
        }
        String searchPath = parameter.getOutputFile();
        if (searchPath == null || searchPath.equals(parameter.getDefaultTableDataPath())) {
            searchPath = parameter.getDefaultDatabasePath();
        }
        File dir = new File(searchPath);
        ArrayList<File> uploadFiles = new ArrayList<File>();
        if (com.oceanbase.tools.loaddump.utils.FileUtils.isValidFilePath(searchPath)) {
            Preconditions.checkState((boolean)dir.exists(), (String)"Upload failed, as schema file doesn't exists! Path: \"{}\"", (Object)dir);
            uploadFiles.add(new File(searchPath));
        } else {
            Collection schemaFiles = FileUtils.listFiles((File)dir, (String[])new String[]{DataFormat.DDL.getDefaultExtension()}, (boolean)true);
            List whiteList = parameter.getWhiteListMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            for (File schemaFile : schemaFiles) {
                String schemaFileName = schemaFile.getName();
                if (!schemaFileName.endsWith("-schema.sql")) continue;
                String objectName = schemaFileName.substring(0, schemaFileName.length() - "-schema.sql".length());
                if (!CollectionUtils.isEmpty(whiteList) && !whiteList.contains(DBUtils.extractObjectName(objectName, null))) continue;
                uploadFiles.add(schemaFile);
            }
        }
        if (CollectionUtils.isNotEmpty(uploadFiles)) {
            log.info("Uploading schema files, which might take a while.");
            this.uploadFiles(parameter, uploadFiles);
        } else {
            log.warn("Schema files(-schema.sql) are not exists. Path: \"{}\"", (Object)dir.getAbsolutePath());
        }
    }

    public void uploadRecordFiles(DumpParameter parameter) throws Exception {
        if (parameter.getStorageConfig() == null || parameter.getUploadBehavior() != UploadBehavior.COMPLETE) {
            return;
        }
        ArrayList<File> uploadFiles = new ArrayList<File>();
        String searchPath = parameter.getOutputFile();
        if (searchPath == null) {
            searchPath = parameter.getDefaultDatabasePath();
        }
        File dir = new File(searchPath);
        if (com.oceanbase.tools.loaddump.utils.FileUtils.isValidFilePath(searchPath)) {
            Preconditions.checkState((boolean)dir.exists(), (String)"Upload failed, as record file doesn't exists. Path: \"{}\"", (Object)dir);
            uploadFiles.add(dir);
        } else {
            String fileSuffix = parameter.getFileSuffix();
            String extension = fileSuffix.startsWith(".") ? fileSuffix.substring(1) : fileSuffix;
            Set tableSet = parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            FileUtils.listFiles((File)dir, (String[])new String[]{extension}, (boolean)true).forEach(dataFile -> {
                String tableName = com.oceanbase.tools.loaddump.utils.FileUtils.getTableName(dataFile.getName());
                if (CollectionUtils.isEmpty((Collection)tableSet) || tableSet.contains(tableName)) {
                    uploadFiles.add((File)dataFile);
                }
            });
            if (CollectionUtils.isEmpty(uploadFiles)) {
                log.warn("Record files(\"{}\") do not exist. Path: \"{}\"", (Object)parameter.getFileSuffix(), (Object)dir);
                return;
            }
        }
        log.info("Uploading record files, which might take a while.");
        this.uploadFiles(parameter, uploadFiles);
    }

    private DumpPostProcessor uploadFiles(DumpParameter parameter, Collection<File> files) throws Exception {
        String outputFile = parameter.getOutputFile();
        String tableDataPath = parameter.getDefaultTableDataPath();
        boolean useCustomPath = outputFile != null && !outputFile.startsWith(tableDataPath) && !org.apache.commons.lang3.StringUtils.substringAfter((String)outputFile, (String)tableDataPath).contains(File.separator);
        try (BatchFileUploader uploader = new BatchFileUploader(FileUploaderFactory.createFileUploader(parameter.getStorageConfig(), parameter.getFilePath(), useCustomPath));){
            int[] result = uploader.uploadBatch(Lists.newArrayList(files));
            int failed = files.size() - Arrays.stream(result).sum();
            Preconditions.checkState((failed < 1 ? 1 : 0) != 0, (String)"Try to upload %s files, but %s files are failed", (int)files.size(), (int)failed);
        }
        return this;
    }
}

