/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.client.DumpClient;
import com.oceanbase.tools.loaddump.client.RemoteDumpClient;
import com.oceanbase.tools.loaddump.cmd.AbstractCommandParser;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.CustomHelpSectionRenderer;
import com.oceanbase.tools.loaddump.cmd.DumpPostProcessor;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.cmd.VersionProvider;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.NumberUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="obdumper", subcommands={CommandLine.HelpCommand.class}, resourceBundle="com.oceanbase.loaddump.bundle.cli", versionProvider=VersionProvider.class, sortOptions=false, header={"@|green    ____                                  ____                       |@", "@|green   / __ \\  _____  ___   ____ _   ____    / __ )  ____ _   _____  ___ |@", "@|green  / / / / / ___/ / _ \\ / __ `/  / __ \\  / __  | / __ `/  / ___/ / _ \\|@", "@|green / /_/ / / /__  /  __// /_/ /  / / / / / /_/ / / /_/ /  (__  ) /  __/|@", "@|green \\____/  \\___/  \\___/ \\__,_/  /_/ /_/ /_____/  \\__,_/  /____/  \\___/ |@", "@|green                                                                     |@"}, footer={"%nExamples:", "@|italic \te.g: ./obdumper -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxxx -D USERA --ddl --all -f /Users/admin/DUMP-1/%n |@", "@|italic \te.g: ./obdumper -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxxx -D USERA --csv --all -f /Users/admin/DUMP-1/%n |@"})
public class Obdumper
extends AbstractCommandParser
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Obdumper.class);
    @CommandLine.Option(names={"--where"}, description={"Interpret to dump data by where condition"})
    private String where;
    @CommandLine.Option(names={"--snapshot"}, description={"Interpret to dump the snapshot data"})
    private boolean snapshot;
    @CommandLine.Option(names={"--weak-read"}, description={"Interpret to dump from follower server"})
    private boolean weakRead;
    @CommandLine.Option(names={"--distinct"}, description={"Interpret to dump the distinct data"})
    private boolean distinct;
    @CommandLine.Option(names={"--page-size"}, description={"Interpret the page size for per query"})
    private int pageSize = 1000000;
    @CommandLine.Option(names={"--commit-size"}, description={"Interpret the commit size for dumper"})
    private int commitSize = 2000;
    @CommandLine.Option(names={"--partition"}, split=",", paramLabel="partition", description={"Interpret to dump data from the partition"})
    private List<String> partitions;
    @CommandLine.Option(names={"--query-sql"}, description={"Interpret to dump data by the custom query sql"})
    private String querySql;
    @CommandLine.Option(names={"--file-name"}, description={"Interpret to merge data files into a large file"})
    private String fileName;
    @CommandLine.Option(names={"--date-value-format"}, description={"Interpret to dump date type record(oboracle) by specified date format"})
    private String dateValueFormat;
    @CommandLine.Option(names={"--datetime-value-format"}, description={"Interpret to dump datetime type record by specified datetime format"})
    private String datetimeValueFormat;
    @CommandLine.Option(names={"--timestamp-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp format"})
    private String timestampValueFormat;
    @CommandLine.Option(names={"--timestamp-tz-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp with time zone format"})
    private String timestampTzValueFormat;
    @CommandLine.Option(names={"--timestamp-ltz-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp with local time zone format"})
    private String timestampLtzValueFormat;
    @CommandLine.Option(names={"--time-value-format"}, description={"Interpret to dump time type record by specified time format"})
    private String timeValueFormat;
    @CommandLine.Option(names={"--drop-object"}, description={"Interpret to prepend drop statement"})
    private boolean dropObject;
    @CommandLine.Option(names={"--skip-check-dir"}, description={"Interpret to check the target dir"})
    private boolean skipCheckDir;
    @CommandLine.Option(names={"--add-extra-message"}, description={"Interpret to dump with extra message"})
    private boolean addExtraMessage;
    @CommandLine.Option(names={"--remove-newline"}, description={"Interpret to remove line break"})
    private boolean removeNewLine;
    @CommandLine.Option(names={"--retain-empty-files"}, description={"Interpret to retain empty files"})
    private boolean retainEmptyFiles;
    @CommandLine.Option(names={"--exclude-virtual-columns"}, description={"Interpret to exclude virtual columns"})
    private boolean excludeVirtualColumns;
    @Deprecated
    @CommandLine.Option(names={"--max-file-size"}, description={"Interpret the max size of output file"})
    private long maxFileSize = -1048576L;
    @CommandLine.Option(names={"--parallel-macro"}, description={"Interpret the parallism of macro list"})
    private int parallelMacro = 8;
    @CommandLine.Option(names={"--flashback-scn"}, description={"Interpret to dump data by flashback scn"})
    private String flashbackScn;
    @CommandLine.Option(names={"--flashback-timestamp"}, description={"Interpret to dump data by flashback timestamp"})
    private String flashbackTimestamp;
    @CommandLine.Option(names={"--block-size"}, description={"Interpret the block size in MB or in record rows for large file"})
    private String blockSize;
    @CommandLine.Option(names={"--upload-behavior"}, description={"Interpret the upload behavior. e.g. FAST, COMPLETE"})
    private String uploadBehavior;
    @CommandLine.Option(names={"--fetch-size"}, description={"Interpret the JDBC variable 'fetchSize' used for performance tuning. Default: 1000"})
    private int fetchSize = 1000;
    @CommandLine.Option(names={"--preserve-zero-datetime"}, description={"Interpret whether to preserve the original form of zero datetime values, which will be converted to null by default."})
    private boolean preserveZeroDatetime = false;

    public static void main(String[] args) {
        Obdumper dumper = new Obdumper();
        CommandLine cmd = new CommandLine((Object)dumper);
        cmd.parseArgs(args);
        boolean isSubHelp = false;
        CustomHelpSectionRenderer custom = new CustomHelpSectionRenderer(TaskType.DUMP);
        if (args.length == 1) {
            for (String key : CustomHelpSectionRenderer.DUMPER_OPTION_MAPPING.keySet()) {
                if (!key.equals(args[0].trim())) continue;
                custom.setDependent(key);
                isSubHelp = true;
                break;
            }
        }
        cmd.getHelpSectionMap().put("optionList", custom);
        cmd.setUsageHelpAutoWidth(true);
        cmd.setUsageHelpLongOptionsMaxWidth(60);
        cmd.setUsageHelpWidth(150);
        if (cmd.isUsageHelpRequested() || args.length == 0 || isSubHelp) {
            cmd.usage(cmd.getOut());
        } else if (cmd.isVersionHelpRequested()) {
            cmd.printVersionHelp(cmd.getOut());
        } else {
            dumper.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.printParseArgs();
        int status = 0;
        RuntimeMetrics metrics = new RuntimeMetrics();
        try {
            DataFormat dataFormat;
            DumpParameter parameter = this.parseCommandArgs();
            if (parameter.isUseServer()) {
                RemoteDumpClient remoteDumpClient = new RemoteDumpClient.Builder(parameter).build();
                Stopwatch stopwatch = Stopwatch.createStarted();
                status = remoteDumpClient.dumpRecords();
                log.info("Remote dump record finished. Total Elapsed: {}", (Object)stopwatch.stop());
                return;
            }
            Set tableSet = parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            boolean notUseCustomQuery = StringUtils.isBlank(parameter.getQuerySql());
            boolean isSingleFile = parameter.getOutputFile() != null && com.oceanbase.tools.loaddump.utils.FileUtils.isValidFilePath(parameter.getOutputFile());
            boolean isMergeConflict = notUseCustomQuery && isSingleFile && tableSet.size() > 1;
            Preconditions.checkArgument((!isMergeConflict ? 1 : 0) != 0, (String)"You can't merge data files to 1 large file for %s tables", (int)tableSet.size());
            if (StringUtils.isNotBlank(parameter.getCtlPath()) && CollectionUtils.isNotEmpty((Collection)tableSet)) {
                this.parseControlFiles(parameter, tableSet);
            }
            DumpClient client = new DumpClient.Builder(parameter).build();
            if (parameter.isIncludeDdl()) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                status = (int)((long)status + super.waitUntilDone(client.dumpSchema()));
                DumpPostProcessor dumpPostProcessor = DumpPostProcessor.INSTANCE;
                dumpPostProcessor.moveSchemaFiles(parameter);
                dumpPostProcessor.uploadSchemaFiles(parameter);
                log.info("Dump schema finished. Total Elapsed: {}", (Object)stopwatch.stop());
            }
            if ((dataFormat = parameter.getDataFormat()) != null && dataFormat != DataFormat.MIX && dataFormat != DataFormat.DDL) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                TaskContext context = client.dumpRecord();
                status = (int)((long)status + super.waitUntilDone(context));
                metrics = context.getRuntimeMetrics();
                DumpPostProcessor dumpPostProcessor = DumpPostProcessor.INSTANCE;
                dumpPostProcessor.mergeRecordFiles(parameter);
                dumpPostProcessor.uploadRecordFiles(parameter);
                log.info("Dump record finished. Total Elapsed: {}", (Object)stopwatch.stop());
            }
        }
        catch (Throwable e) {
            status = 1;
            if (JvmArgs.isMultiTask) {
                if (JvmArgs.isDebugable) {
                    log.error("Dump failed!", e);
                } else {
                    log.error("Dump failed! Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                }
            } else {
                if (JvmArgs.isDebugable) {
                    e.printStackTrace();
                }
                LogUtils.error("Dump failed! Error: {}", ExceptionUtils.getRootCauseMessage(e));
            }
        }
        finally {
            this.doFinally(metrics, status);
        }
    }

    @Override
    protected DumpParameter parseCommandArgs() throws Exception {
        DumpParameter parameter = new DumpParameter();
        super.parseCommonArgs(parameter);
        Common.Base base = this.common.getBase();
        if (!base.isUseServer()) {
            File dir = new File(base.getFilePath());
            com.oceanbase.tools.loaddump.utils.FileUtils.checkValidDirectory(dir);
            parameter.setFilePath(dir.getAbsolutePath());
        } else {
            parameter.setFilePath(base.getFilePath());
            if (parameter.getColumnDelimiter().charValue() == '\'') {
                parameter.setColumnDelimiter(Character.valueOf('\"'));
            }
        }
        boolean useFlashback = StringUtils.isNotEmpty(this.getFlashbackScn()) || StringUtils.isNotEmpty(this.getFlashbackTimestamp());
        Preconditions.checkArgument((!this.isSnapshot() || !useFlashback ? 1 : 0) != 0, (Object)"Option --snapshot can not be used with --flashback-scn or --flashback-timestamp");
        String querySql = StringUtils.trim((String)this.getQuerySql());
        boolean useCustomSql = StringUtils.isNotBlank(querySql);
        if (useCustomSql && querySql.endsWith(";")) {
            querySql = querySql.substring(0, querySql.length() - 1);
        }
        Preconditions.checkArgument((!useCustomSql || !parameter.isIncludeDdl() ? 1 : 0) != 0, (Object)"Option --ddl and --query-sql can not be specified at the same time.");
        Preconditions.checkArgument((!base.isEnableHiddenPk() || !useCustomSql ? 1 : 0) != 0, (Object)"Option --enable-hidden-pk and --query-sql can not be specified at the same time.");
        parameter.setQuerySql(querySql);
        parameter.setDistinct(this.isDistinct());
        parameter.setSnapshot(this.isSnapshot());
        parameter.setWeakRead(this.isWeakRead());
        parameter.setDroppable(this.isDropObject());
        int pageSize = this.getPageSize();
        if (pageSize != 1000000) {
            pageSize = Math.min(Math.max(pageSize, 300000), 5000000);
        }
        parameter.setPageSize(pageSize);
        this.setProperUploadBehavior(parameter);
        parameter.setMaxFileSize(this.getMaxFileSize());
        parameter.setSkipCheckDir(this.isSkipCheckDir());
        parameter.setWithExtra(this.isAddExtraMessage());
        parameter.setFlashbackScn(this.getFlashbackScn());
        parameter.setRemoveNewline(this.isRemoveNewLine());
        parameter.setParallelMacros(this.getParallelMacro());
        parameter.setRetainEmptyFiles(this.isRetainEmptyFiles());
        parameter.setFlashbackTimestamp(this.getFlashbackTimestamp());
        parameter.setWhereClause(DBUtils.wrapWhereClause(this.getWhere()));
        parameter.setExcludeVirtualColumns(this.isExcludeVirtualColumns());
        parameter.setFetchSize(this.getFetchSize());
        parameter.setPreserveZeroDatetime(this.isPreserveZeroDatetime());
        if (StringUtils.isNotBlank(this.getTimeValueFormat())) {
            parameter.setTimeValuePattern(this.getTimeValueFormat());
        }
        if (StringUtils.isNotBlank(this.getDatetimeValueFormat())) {
            parameter.setDatetimeValuePattern(this.getDatetimeValueFormat());
        }
        if (StringUtils.isNotBlank(this.getTimestampTzValueFormat())) {
            parameter.setTimestampTzValuePattern(this.getTimestampTzValueFormat());
        }
        if (StringUtils.isNotBlank(this.getTimestampLtzValueFormat())) {
            parameter.setTimestampLtzValuePattern(this.getTimestampLtzValueFormat());
        }
        if (!base.isSql() && StringUtils.isNotBlank(this.getDateValueFormat())) {
            parameter.setDateValuePattern(this.getDateValueFormat());
        }
        if (!base.isSql() && StringUtils.isNotBlank(this.getTimestampValueFormat())) {
            parameter.setTimestampValuePattern(this.getTimestampValueFormat());
        }
        if (this.getPartitions() != null) {
            Set<String> partitions = this.getPartitions().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(partitions), (Object)"Cli args of --partition is required");
            parameter.setPartitions(partitions);
        }
        ObjectTypes objects = this.common.getObjectTypes();
        if (useCustomSql) {
            ArrayList tableNames = objects == null ? Lists.newArrayList((Object[])new String[]{"CUSTOM_SQL"}) : objects.getTables();
            Preconditions.checkArgument((tableNames.size() < 2 ? 1 : 0) != 0, (Object)"Option --table should contain 1 table name for --query-sql at most");
            String tableName = StringUtils.isBlank((CharSequence)tableNames.get(0)) || "*".equals(tableNames.get(0)) ? "CUSTOM_SQL" : (String)tableNames.get(0);
            parameter.getWhiteListMap().put(ObjectType.TABLE, Sets.newHashSet((Object[])new String[]{tableName}));
        } else {
            Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Option --all, --table or other object options are missing");
            parameter.getWhiteListMap().putAll(this.parseAllowedObjects(objects));
            parameter.getBlackListMap().putAll(this.parseDisallowedObjects(objects));
        }
        DataFormat dataFormat = parameter.getDataFormat();
        Set<String> tableSet = parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        if (parameter.isIncludeDdl() && dataFormat == null) {
            dataFormat = DataFormat.DDL;
            parameter.setDataFormat(dataFormat);
        }
        Preconditions.checkArgument((dataFormat != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        if (!parameter.isIncludeDdl()) {
            parameter.getWhiteListMap().clear();
            parameter.getWhiteListMap().put(ObjectType.TABLE, tableSet);
        }
        parameter.setOutputFile(this.parseFileName(parameter, this.getFileName()));
        String fileSuffix = base.getFileSuffix();
        Preconditions.checkArgument((StringUtils.isBlank(fileSuffix) || fileSuffix.startsWith(".") ? 1 : 0) != 0, (Object)"Option --file-suffix should start with dot('.'), e.g: '.csv'");
        parameter.setFileSuffix(StringUtils.isNotBlank(fileSuffix) ? fileSuffix : dataFormat.getDefaultFileSuffix());
        this.parseBlockSize(parameter, dataFormat, this.getBlockSize());
        Preconditions.checkArgument((this.getCommitSize() > 0 ? 1 : 0) != 0, (Object)"Option --commit-size should be a positive integer.");
        parameter.setCommitSize(this.getCommitSize());
        boolean isSkipHeader = base.isSkipHeader() || parameter.getOutputFile() != null;
        parameter.setSkipHeader(isSkipHeader);
        return parameter;
    }

    public void parseBlockSize(DumpParameter param, DataFormat dataFormat, String blockSizeRaw) throws IllegalArgumentException {
        int cutIdx;
        Preconditions.checkArgument((!"".equals(blockSizeRaw) ? 1 : 0) != 0, (Object)"Option --block-size can not be empty");
        Preconditions.checkArgument((blockSizeRaw == null || !dataFormat.isColumnOrientedFormat() ? 1 : 0) != 0, (Object)"Option --block-size is not used for ORC/Parquet currently");
        if (blockSizeRaw == null) {
            param.setBlockSize(dataFormat.isColumnOrientedFormat() ? -1L : 0x40000000L);
            param.setBlockSizeUnit("MB");
            return;
        }
        for (cutIdx = 0; cutIdx < blockSizeRaw.length() && Character.isDigit(blockSizeRaw.charAt(cutIdx)); ++cutIdx) {
        }
        long blockSize = Long.parseLong(blockSizeRaw.substring(0, cutIdx));
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (Object)"Option --block-size should be larger than 0 MB(ROW).");
        String blockSizeUnit = blockSizeRaw.substring(cutIdx);
        if ("".equals(blockSizeUnit) || "MB".equalsIgnoreCase(blockSizeUnit)) {
            param.setBlockSize(blockSize * 0x100000L);
            param.setBlockSizeUnit("MB");
        } else if ("ROW".equalsIgnoreCase(blockSizeUnit)) {
            param.setBlockSize(blockSize);
            param.setBlockSizeUnit("ROW");
        } else {
            throw new IllegalArgumentException("Unit of --block-size: \"" + blockSizeUnit + "\" is unsupported. Expected: ROW, MB");
        }
    }

    private String parseFileName(DumpParameter parameter, String fileName) throws IOException {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        Preconditions.checkArgument(("*".equals(fileName = fileName.trim()) || !fileName.contains("*") ? 1 : 0) != 0, (Object)"Wildcard('*') is not allowed in the path. It only used to merge data files.");
        if (!fileName.contains(File.separator)) {
            return parameter.getDefaultTableDataPath() + fileName.replace("*", "");
        }
        File tmpFile = new File(fileName).getCanonicalFile();
        if (com.oceanbase.tools.loaddump.utils.FileUtils.isValidDirPath(fileName)) {
            Preconditions.checkArgument((boolean)tmpFile.exists(), (Object)"Option --file-name specify a directory that doesn't exist.");
        } else {
            Preconditions.checkArgument((!tmpFile.exists() || tmpFile.isFile() ? 1 : 0) != 0, (Object)"Intend to specify --file-name as a directory? You may add '/' to the tail of the path.");
            boolean includeSchemaAndData = parameter.isIncludeDdl() && parameter.getDataFormat() != DataFormat.DDL;
            Preconditions.checkArgument((!includeSchemaAndData ? 1 : 0) != 0, (Object)"Option --file-name shouldn't be a file path, as both --ddl and one of the data format options are specified.");
            int objectCount = 0;
            for (Set<String> objectSet : parameter.getWhiteListMap().values()) {
                Preconditions.checkArgument(((objectCount += Math.max(1, objectSet.size())) <= 1 && !objectSet.isEmpty() ? 1 : 0) != 0, (Object)"Option --file-name shouldn't be a file path, as more than one schema or table need to be dumped.");
            }
        }
        String canonicalPath = tmpFile.getPath();
        return com.oceanbase.tools.loaddump.utils.FileUtils.isValidDirPath(fileName) && !canonicalPath.endsWith(File.separator) ? canonicalPath + File.separator : canonicalPath;
    }

    private void setProperUploadBehavior(DumpParameter parameter) {
        if (parameter.getStorageConfig() == null) {
            return;
        }
        String behaviorString = this.getUploadBehavior();
        if (StringUtils.isBlank(behaviorString)) {
            UploadBehavior behavior = StringUtils.isNotBlank(this.getFileName()) ? UploadBehavior.COMPLETE : UploadBehavior.FAST;
            parameter.setUploadBehavior(behavior);
            this.uploadBehavior = behavior.getName();
        } else {
            UploadBehavior behavior = UploadBehavior.of(behaviorString);
            parameter.setUploadBehavior(behavior);
            if (StringUtils.isNotBlank(this.getFileName()) && behavior == UploadBehavior.FAST) {
                LogUtils.warn("Option --upload-behavior is specified as 'FAST', option --file-name will be disabled.");
            }
        }
    }

    @Override
    protected void logProgress(TaskContext context, long counter) {
        super.logProgress(context, counter);
        if (counter % 15L == 0L && UploadBehavior.FAST.getName().equalsIgnoreCase(this.uploadBehavior)) {
            Collection<TaskDetail> taskDetails = context.getAllTaskDetails();
            int activeCount = taskDetails.stream().mapToInt(t -> t.getUploadTask().getActiveCount()).sum();
            int totalCount = taskDetails.stream().mapToInt(t -> t.getUploadTask().getTotalCount()).sum();
            long bytesWritten = taskDetails.stream().mapToLong(t -> t.getUploadTask().getTotalBytesWritten()).sum();
            if (context.isUploading()) {
                context.stopLogReporter();
                long totalBytes = taskDetails.stream().mapToLong(t -> t.getUploadTask().getTotalBytes()).sum();
                log.info("Upload Progress: Files Amount: {}/{}, Total Size: {}/{}, Percentage: {}\n", new Object[]{totalCount - activeCount, totalCount, FileUtils.byteCountToDisplaySize((long)bytesWritten), FileUtils.byteCountToDisplaySize((long)totalBytes), NumberUtils.toScaledBigDecimal(new BigDecimal((double)(totalCount - activeCount) * 100.0 / (double)totalCount))});
            } else {
                log.info("Upload Progress: Files Amount: {}, Total Size: {}\n", (Object)(totalCount - activeCount), (Object)FileUtils.byteCountToDisplaySize((long)bytesWritten));
            }
        }
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public boolean isWeakRead() {
        return this.weakRead;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDateValueFormat() {
        return this.dateValueFormat;
    }

    public String getDatetimeValueFormat() {
        return this.datetimeValueFormat;
    }

    public String getTimestampValueFormat() {
        return this.timestampValueFormat;
    }

    public String getTimestampTzValueFormat() {
        return this.timestampTzValueFormat;
    }

    public String getTimestampLtzValueFormat() {
        return this.timestampLtzValueFormat;
    }

    public String getTimeValueFormat() {
        return this.timeValueFormat;
    }

    public boolean isDropObject() {
        return this.dropObject;
    }

    public boolean isSkipCheckDir() {
        return this.skipCheckDir;
    }

    public boolean isAddExtraMessage() {
        return this.addExtraMessage;
    }

    public boolean isRemoveNewLine() {
        return this.removeNewLine;
    }

    public boolean isRetainEmptyFiles() {
        return this.retainEmptyFiles;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    @Deprecated
    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getParallelMacro() {
        return this.parallelMacro;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public String getFlashbackTimestamp() {
        return this.flashbackTimestamp;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public String getUploadBehavior() {
        return this.uploadBehavior;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isPreserveZeroDatetime() {
        return this.preserveZeroDatetime;
    }
}

