/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public class Database
implements Serializable {
    private static final long serialVersionUID = 2889551590557210758L;
    private boolean logicalDatabase;
    private boolean subsequentV4;
    private ServerMode serverMode;
    private String schemaName;
    private List<String> tableNames;
    private Map<String, TableInfo> tableInfoMap;
    private Set<String> viewInfoSet;
    private Set<String> triggerInfoSet;
    private Set<String> sequenceInfoSet;
    private Set<String> functionInfoSet;
    private Set<String> procedureInfoSet;

    public Database() {
        this(null);
    }

    public Database(String schemaName) {
        this.schemaName = schemaName;
        this.tableInfoMap = new HashMap<String, TableInfo>(0);
    }

    public List<String> getTableNames() {
        if (this.tableNames != null) {
            return this.tableNames;
        }
        Set<Object> tableSet = MapUtils.isEmpty(this.tableInfoMap) ? Sets.newHashSet() : this.tableInfoMap.keySet();
        this.tableNames = Lists.newArrayList((Iterable)tableSet);
        this.tableNames.sort((o1, o2) -> Integer.compare(o2.length(), o1.length()));
        return this.tableNames;
    }

    public TableInfo getTableInfo(String table) {
        return this.tableInfoMap.get(table);
    }

    public boolean isOracleMode() {
        return this.serverMode == ServerMode.ORACLE;
    }

    public String toString() {
        return "Database{schemaName='" + this.schemaName + '\'' + '}';
    }

    public boolean isLogicalDatabase() {
        return this.logicalDatabase;
    }

    public void setLogicalDatabase(boolean logicalDatabase) {
        this.logicalDatabase = logicalDatabase;
    }

    public boolean isSubsequentV4() {
        return this.subsequentV4;
    }

    public void setSubsequentV4(boolean subsequentV4) {
        this.subsequentV4 = subsequentV4;
    }

    public ServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(ServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Map<String, TableInfo> getTableInfoMap() {
        return this.tableInfoMap;
    }

    public void setTableInfoMap(Map<String, TableInfo> tableInfoMap) {
        this.tableInfoMap = tableInfoMap;
    }

    public Set<String> getViewInfoSet() {
        return this.viewInfoSet;
    }

    public void setViewInfoSet(Set<String> viewInfoSet) {
        this.viewInfoSet = viewInfoSet;
    }

    public Set<String> getTriggerInfoSet() {
        return this.triggerInfoSet;
    }

    public void setTriggerInfoSet(Set<String> triggerInfoSet) {
        this.triggerInfoSet = triggerInfoSet;
    }

    public Set<String> getSequenceInfoSet() {
        return this.sequenceInfoSet;
    }

    public void setSequenceInfoSet(Set<String> sequenceInfoSet) {
        this.sequenceInfoSet = sequenceInfoSet;
    }

    public Set<String> getFunctionInfoSet() {
        return this.functionInfoSet;
    }

    public void setFunctionInfoSet(Set<String> functionInfoSet) {
        this.functionInfoSet = functionInfoSet;
    }

    public Set<String> getProcedureInfoSet() {
        return this.procedureInfoSet;
    }

    public void setProcedureInfoSet(Set<String> procedureInfoSet) {
        this.procedureInfoSet = procedureInfoSet;
    }
}

