/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.concurrent.FlowLimiter;
import com.oceanbase.tools.loaddump.concurrent.TpsBasedFlowLimiter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.util.List;

public class LoadParameter
extends BaseParameter {
    private boolean failFast = true;
    private File inputFile;
    private List<SubFile> subFiles;
    private boolean ignoreUnhex;
    private boolean ignoreEscape;
    private boolean skipFooter = false;
    private int batchSize = 200;
    private boolean external = false;
    private int maxErrors = 1000;
    private int maxDiscards = 1000;
    private boolean strict = true;
    private boolean deleteable;
    private boolean truncatable;
    private boolean truncateWithDataFile;
    private boolean replaceObjectIfExists;
    private boolean replaceData;
    protected String fileNameRegExp;
    private int tpsLimit = Integer.MAX_VALUE;
    private int bufferSize = 500000;
    private double readWriteRatio = 1.0;
    private double slowInsertThreshold = 0.75;
    private double pauseInsertThreshold = 0.85;
    private long maxWaitTimeMillis = 10800000L;
    private boolean directMode = false;

    public FlowLimiter createFlowLimiter() {
        return new TpsBasedFlowLimiter(this.getTpsLimit());
    }

    @Override
    public String getDataPath() {
        return this.isExternal() ? super.getFilePath() : super.getDataPath();
    }

    public String getCheckpointPath() {
        return FileUtils.toPath(this.getDataPath(), "load.ckpt");
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public List<SubFile> getSubFiles() {
        return this.subFiles;
    }

    public void setSubFiles(List<SubFile> subFiles) {
        this.subFiles = subFiles;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public void setIgnoreUnhex(boolean ignoreUnhex) {
        this.ignoreUnhex = ignoreUnhex;
    }

    public boolean isIgnoreEscape() {
        return this.ignoreEscape;
    }

    public void setIgnoreEscape(boolean ignoreEscape) {
        this.ignoreEscape = ignoreEscape;
    }

    @Override
    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    @Override
    public void setSkipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public void setMaxDiscards(int maxDiscards) {
        this.maxDiscards = maxDiscards;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isDeleteable() {
        return this.deleteable;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    public boolean isTruncatable() {
        return this.truncatable;
    }

    public void setTruncatable(boolean truncatable) {
        this.truncatable = truncatable;
    }

    public boolean isTruncateWithDataFile() {
        return this.truncateWithDataFile;
    }

    public void setTruncateWithDataFile(boolean truncateWithDataFile) {
        this.truncateWithDataFile = truncateWithDataFile;
    }

    public boolean isReplaceObjectIfExists() {
        return this.replaceObjectIfExists;
    }

    public void setReplaceObjectIfExists(boolean replaceObjectIfExists) {
        this.replaceObjectIfExists = replaceObjectIfExists;
    }

    public boolean isReplaceData() {
        return this.replaceData;
    }

    public void setReplaceData(boolean replaceData) {
        this.replaceData = replaceData;
    }

    public void setFileNameRegExp(String fileNameRegExp) {
        this.fileNameRegExp = fileNameRegExp;
    }

    public String getFileNameRegExp() {
        return this.fileNameRegExp;
    }

    public int getTpsLimit() {
        return this.tpsLimit;
    }

    public void setTpsLimit(int tpsLimit) {
        this.tpsLimit = tpsLimit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public double getReadWriteRatio() {
        return this.readWriteRatio;
    }

    public void setReadWriteRatio(double readWriteRatio) {
        this.readWriteRatio = readWriteRatio;
    }

    public double getSlowInsertThreshold() {
        return this.slowInsertThreshold;
    }

    public void setSlowInsertThreshold(double slowInsertThreshold) {
        this.slowInsertThreshold = slowInsertThreshold;
    }

    public double getPauseInsertThreshold() {
        return this.pauseInsertThreshold;
    }

    public void setPauseInsertThreshold(double pauseInsertThreshold) {
        this.pauseInsertThreshold = pauseInsertThreshold;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTimeMillis;
    }

    public void setMaxWaitTimeMillis(long maxWaitTimeMillis) {
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    public boolean isDirectMode() {
        return this.directMode;
    }

    public void setDirectMode(boolean directMode) {
        this.directMode = directMode;
    }
}

