/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.LoadStatus;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class ServerStatus {
    static final String TITLE = "\n\n(OceanBase Server Status)";
    static final String FORMAT = "\n\tLeader Server: %s \t Merge Status: %s \t Mem Used Ratio: %s \t Load Mode: %s \t Partition: [%s] ";
    static final String HORIZEN_LINE = "\n-----------------------------------------------------------------------------------------------------------------\n";
    private Map<String, Map<Long, LoadStatus>> loadStatusMap;

    public ServerStatus(Map<String, Map<Long, LoadStatus>> loadStatusMap) {
        this.loadStatusMap = Collections.unmodifiableMap(loadStatusMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (MapUtils.isEmpty(this.loadStatusMap)) {
            return "No Server Status";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TITLE).append(HORIZEN_LINE);
        for (Map.Entry<String, Map<Long, LoadStatus>> e1 : this.loadStatusMap.entrySet()) {
            sb.append("Table: \"").append(e1.getKey()).append("\"\n");
            Set<Map.Entry<Long, LoadStatus>> loadStatusMapSet = e1.getValue().entrySet();
            LinkedHashMap<String, LeaderStatus> leaderStatusMap = new LinkedHashMap<String, LeaderStatus>();
            try {
                for (Map.Entry<Long, LoadStatus> entry : loadStatusMapSet) {
                    String leaderServer = entry.getValue().getLeaderServer();
                    leaderStatusMap.putIfAbsent(leaderServer, new LeaderStatus());
                    LeaderStatus loadStatus = (LeaderStatus)leaderStatusMap.get(leaderServer);
                    loadStatus.setLoadStatus(entry.getValue());
                    loadStatus.getPartitionIds().add(entry.getKey());
                }
                for (Map.Entry<Long, LoadStatus> entry : leaderStatusMap.entrySet()) {
                    LoadStatus status = ((LeaderStatus)((Object)entry.getValue())).getLoadStatus();
                    sb.append(String.format(FORMAT, new Object[]{entry.getKey(), status.isMerging(), status.getMemUsedPercent(), status.getLoadMode(), ((LeaderStatus)((Object)entry.getValue())).getPartitionIdsString()}));
                }
            }
            finally {
                leaderStatusMap.clear();
            }
            sb.append("\n\n");
        }
        return sb.append("\n").toString();
    }

    public Map<String, Map<Long, LoadStatus>> getLoadStatusMap() {
        return this.loadStatusMap;
    }

    static class LeaderStatus {
        private final Set<Long> partitionIds = new LinkedHashSet<Long>();
        private LoadStatus loadStatus;

        LeaderStatus() {
        }

        public String getPartitionIdsString() {
            return this.getPartitionIds().stream().map(String::valueOf).collect(Collectors.joining(","));
        }

        public Set<Long> getPartitionIds() {
            return this.partitionIds;
        }

        public LoadStatus getLoadStatus() {
            return this.loadStatus;
        }

        public void setLoadStatus(LoadStatus loadStatus) {
            this.loadStatus = loadStatus;
        }
    }
}

