/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;

public class StorageUri {
    private String uri;
    private String scheme;
    private String container;
    private String path;
    private HashMap<String, String> parameters = new HashMap();
    private static final HashSet<String> SENSITIVE_PARAMETERS = new HashSet();

    public static StorageUri newFromUri(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        StorageUri storageUri = new StorageUri();
        storageUri.uri = uri;
        int schemeEnd = uri.indexOf("://");
        Preconditions.checkArgument((schemeEnd != -1 ? 1 : 0) != 0, (Object)"Invalid URI, which should starts with \"scheme://\".");
        int pathEnd = 0;
        storageUri.scheme = uri.substring(0, schemeEnd);
        int containerEnd = uri.indexOf(47, schemeEnd + 3);
        if (containerEnd == -1) {
            storageUri.path = "";
            int paramStart = uri.indexOf(63, schemeEnd + 3);
            pathEnd = containerEnd = paramStart != -1 ? paramStart : uri.length();
        } else {
            pathEnd = uri.indexOf(63, containerEnd);
            String path = pathEnd != -1 ? uri.substring(containerEnd + 1, pathEnd) : uri.substring(containerEnd + 1);
            boolean pathStartWithSeparator = path.startsWith("/");
            path = Arrays.stream(path.split("/")).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
            storageUri.path = pathStartWithSeparator ? "/" + path : path;
        }
        storageUri.container = uri.substring(schemeEnd + 3, containerEnd);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(storageUri.container), (Object)"Invalid URI, container is missing.");
        if (pathEnd != -1 && pathEnd < uri.length() - 1) {
            String[] parameterPairs;
            String parametersString = uri.substring(pathEnd + 1);
            for (String pair : parameterPairs = parametersString.split("&")) {
                String key = StringUtils.substringBefore((String)pair, (String)"=");
                String value = StringUtils.substringAfter((String)pair, (String)"=");
                storageUri.parameters.put(key, value);
            }
        }
        return storageUri;
    }

    public String getUriWithoutParam() {
        return StringUtils.substringBefore((String)this.uri, (String)"?");
    }

    public static String maskSensitiveParams(String url) {
        if (StringUtils.isBlank(url)) {
            return url;
        }
        String[] parts = StringUtils.split((String)url, (String)"?", (int)2);
        if (parts.length < 2) {
            return url;
        }
        String query = parts[1];
        String[] params = StringUtils.split((String)query, (String)"&");
        StringBuilder sb = new StringBuilder();
        String maskedValue = "******";
        for (int i = 0; i < params.length; ++i) {
            String[] kv = StringUtils.split((String)params[i], (String)"=");
            if (kv.length != 2) continue;
            String key = kv[0];
            String value = kv[1];
            if (SENSITIVE_PARAMETERS.contains(key)) {
                value = maskedValue;
            }
            sb.append(key).append("=").append(value);
            if (i >= params.length - 1) continue;
            sb.append("&");
        }
        return parts[0] + "?" + sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageUri)) {
            return false;
        }
        StorageUri that = (StorageUri)o;
        return Objects.equals(this.getScheme(), that.getScheme()) && Objects.equals(this.getContainer(), that.getContainer()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hash(this.getScheme(), this.getContainer(), this.getPath(), this.getParameters());
    }

    public String toString() {
        return "StorageUri{scheme='" + this.scheme + '\'' + ", container='" + this.container + '\'' + ", path='" + this.path + '\'' + ", parameters=" + this.parameters + '}';
    }

    public String getUri() {
        return this.uri;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    static {
        SENSITIVE_PARAMETERS.add(UriParams.ACCESS_KEY.getName());
        SENSITIVE_PARAMETERS.add(UriParams.SECRET_KEY.getName());
    }

    public static enum UriParams {
        ENDPOINT_KEY("endpoint"),
        REGION_KEY("region"),
        ACCESS_KEY("access-key"),
        SECRET_KEY("secret-key"),
        STORAGE_CLASS_KEY("storage-class"),
        HDFS_PRINCIPAL_KEY("principal"),
        HDFS_KEYTAB_PATH_KEY("keytab-file"),
        CORE_SITE_FILE("core-site-file"),
        HDFS_SITE_FILE("hdfs-site-file"),
        KRB5_CONF_FILE("krb5-conf-file");

        public final String name;

        private UriParams(String name) {
            this.name = name;
        }

        public UriParams of(String key) {
            for (UriParams uriParams : UriParams.values()) {
                if (!uriParams.name.equals(key)) continue;
                return uriParams;
            }
            throw new IllegalArgumentException("Invalid storage uri parameter: " + key);
        }

        public String getName() {
            return this.name;
        }
    }
}

