/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.context;

import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalContext {
    private final int maxErrors;
    private final int maxDiscards;
    private final Map<String, AtomicInteger> discardMap;
    private final Map<String, AtomicInteger> errCntMap;
    private final boolean strict;
    private final boolean fastFail;

    public GlobalContext(LoadParameter parameter) {
        this.maxErrors = parameter.getMaxErrors();
        this.maxDiscards = parameter.getMaxDiscards();
        this.discardMap = new ConcurrentHashMap<String, AtomicInteger>();
        this.errCntMap = new ConcurrentHashMap<String, AtomicInteger>();
        this.strict = parameter.isStrict();
        this.fastFail = parameter.isDirectMode();
    }

    public void initContext(String tableName) {
        this.errCntMap.putIfAbsent(tableName, new AtomicInteger(0));
        this.discardMap.putIfAbsent(tableName, new AtomicInteger(0));
    }

    public AtomicInteger incrementErrorCount(String tableName) {
        AtomicInteger count = this.errCntMap.computeIfAbsent(tableName, v -> new AtomicInteger(0));
        count.incrementAndGet();
        return count;
    }

    public AtomicInteger getErrorCount(String tableName) {
        return this.errCntMap.get(tableName);
    }

    public boolean isExceedMaxErrors(String tableName) {
        AtomicInteger count = this.errCntMap.getOrDefault(tableName, null);
        return count != null && this.maxErrors >= 0 && count.get() > this.maxErrors;
    }

    public boolean incrementAndIsExceedMaxErrors(String tableName) {
        this.incrementErrorCount(tableName);
        return this.isExceedMaxErrors(tableName);
    }

    public boolean isExceedMaxDiscards(String tableName) {
        AtomicInteger count = this.discardMap.getOrDefault(tableName, null);
        return count != null && this.maxDiscards >= 0 && count.get() > this.maxDiscards;
    }

    public AtomicInteger incrementDiscardCount(String tableName) {
        AtomicInteger count = this.discardMap.computeIfAbsent(tableName, v -> new AtomicInteger(0));
        count.incrementAndGet();
        return count;
    }

    public boolean incrementAndIsExceedMaxDiscards(String tableName) {
        this.incrementDiscardCount(tableName);
        return this.isExceedMaxDiscards(tableName);
    }

    public boolean shouldFail(String tableName, TaskState state) {
        return state == TaskState.FAILURE && this.fastFail || this.isExceedMaxErrors(tableName) || this.isExceedMaxDiscards(tableName);
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public Map<String, AtomicInteger> getDiscardMap() {
        return this.discardMap;
    }

    public Map<String, AtomicInteger> getErrCntMap() {
        return this.errCntMap;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isFastFail() {
        return this.fastFail;
    }
}

