/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.assembler;

import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleStatementAssembler
extends AbstractStatementAssembler {
    private static final Logger log = LoggerFactory.getLogger(ObOracleStatementAssembler.class);

    public ObOracleStatementAssembler(DumpParameter parameter) {
        super(parameter);
    }

    public ObOracleStatementAssembler(TableRangeInfo tableRangeInfo, DumpParameter parameter, long dataVersion) {
        super(tableRangeInfo, parameter, dataVersion);
    }

    @Override
    protected CharSequence getFlashbackClause() {
        if (!this.parameter.isSnapshot() && this.sub2270) {
            StringBuilder sb = new StringBuilder(64);
            if (StringUtils.isNotBlank(this.parameter.getFlashbackScn())) {
                return sb.append(" AS OF SCN ").append(this.parameter.getFlashbackScn());
            }
            if (StringUtils.isNotBlank(this.parameter.getFlashbackTimestamp())) {
                sb.append(" AS OF TIMESTAMP TO_TIMESTAMP('");
                sb.append(this.parameter.getFlashbackTimestamp());
                return sb.append("','yyyy-mm-dd hh24:mi:ss')");
            }
        }
        return "";
    }

    @Override
    protected CharSequence getPartitionName() {
        return this.tableRangeInfo.isPartitioned() ? " partition(" + ServerMode.ORACLE.wrapName(this.tableRangeInfo.getPartitionName()) + ")" : "";
    }

    public ObOracleStatementAssembler() {
    }
}

