/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task;

import com.oceanbase.tools.loaddump.dumper.uploader.BytesProgressListener;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class UploadTask {
    private int totalCount = 0;
    private final AtomicLong totalBytesWritten = new AtomicLong(0L);
    private long totalBytes = 0L;
    private final List<File> failedFiles = Collections.synchronizedList(new ArrayList());
    private final Map<File, BytesProgressListener> activeFiles = new ConcurrentHashMap<File, BytesProgressListener>();

    public boolean isFinished() {
        return this.getActiveCount() == 0;
    }

    public boolean isFailure() {
        return this.failedFiles.size() > 0;
    }

    public int getActiveCount() {
        return this.activeFiles.size();
    }

    public void begin(File file, BytesProgressListener listener) {
        this.activeFiles.put(file, listener);
        this.totalBytes += FileUtils.getSize(file);
        ++this.totalCount;
    }

    public void commit(File file, long size) {
        this.totalBytesWritten.addAndGet(size);
        this.activeFiles.remove(file);
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get() + this.activeFiles.values().stream().mapToLong(l -> l.getBytesWritten().get()).sum();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public List<File> getFailedFiles() {
        return this.failedFiles;
    }

    public Map<File, BytesProgressListener> getActiveFiles() {
        return this.activeFiles;
    }
}

