/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;

public class CutRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private CsvFormat csvFormat;
    private String columnSplitter;
    private boolean removeNewline;

    public CutRecordTranslator(TableInfo tableInfo, ControlManager controlManager, CsvFormat csvFormat, String columnSplitter, boolean removeNewline) {
        this.tableInfo = tableInfo;
        this.csvFormat = csvFormat;
        this.removeNewline = removeNewline;
        this.controlManager = controlManager;
        this.columnSplitter = columnSplitter;
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder(4096);
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        boolean isNotNull;
        boolean bl = isNotNull = columnValue != null;
        if (!isNotNull) {
            columnValue = this.csvFormat.getNullString();
        } else {
            if (this.csvFormat.getTrim()) {
                columnValue = columnValue.trim();
            }
            if (columnValue.isEmpty()) {
                columnValue = this.csvFormat.getEmptyString();
            } else {
                boolean isNeedEscape = this.tableInfo.isNeedEscape(index);
                if (isNeedEscape) {
                    columnValue = this.escapeString(columnValue, this.csvFormat.getEscapeCharacter(), this.columnSplitter, this.csvFormat.getRecordSeparator());
                }
                if (this.removeNewline) {
                    columnValue = columnValue.replaceAll("[\r\n]", "");
                }
            }
        }
        recordPattern.append(columnValue);
        if (hasNext || !this.csvFormat.getTrailingDelimiter()) {
            recordPattern.append(this.columnSplitter);
        }
        return recordPattern;
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(this.csvFormat.getRecordSeparator());
    }

    public String escapeString(String columnValue, Character escapeChar, String columnSplitter, String lineSeparator) {
        int length = columnValue.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            boolean isMatchLineSeparator;
            char c = columnValue.charAt(i);
            boolean isMatchColumnSplitter = columnSplitter.length() > 0 && c == columnSplitter.charAt(0) && columnValue.startsWith(columnSplitter, i);
            boolean bl = isMatchLineSeparator = lineSeparator.length() > 0 && c == lineSeparator.charAt(0) && columnValue.startsWith(lineSeparator, i);
            if (c == escapeChar.charValue() || isMatchColumnSplitter || isMatchLineSeparator) {
                sb.append(escapeChar);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

