/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.uploader;

import com.oceanbase.tools.loaddump.concurrent.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.dumper.task.UploadTask;
import com.oceanbase.tools.loaddump.dumper.uploader.BytesProgressListener;
import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFileUploader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AsyncFileUploader.class);
    private final FileUploader fileUploader;
    private final ExecutorService executor;
    private final List<CompletableFuture<Void>> jobs = Collections.synchronizedList(new ArrayList());
    private UploadTask uploadTask;

    public AsyncFileUploader(FileUploader fileUploader) {
        this.executor = new ThreadPoolBuilder().setCorePoolSize(1).setThreadPrefixName("upload-file-thread-").build();
        this.fileUploader = fileUploader;
    }

    public void submitUpload(File file) {
        CompletionStage job = CompletableFuture.runAsync(() -> {
            try {
                long fileSize = FileUtils.getSize(file);
                BytesProgressListener listener = new BytesProgressListener();
                this.uploadTask.begin(file, listener);
                this.fileUploader.upload(file, listener);
                this.uploadTask.commit(file, fileSize);
            }
            catch (Throwable e) {
                this.uploadTask.commit(file, 0L);
                throw new CompletionException(e);
            }
        }, this.executor).exceptionally(e -> {
            this.uploadTask.getFailedFiles().add(file);
            return null;
        });
        this.jobs.add((CompletableFuture<Void>)job);
    }

    public String getDestUri() {
        return this.fileUploader.getDestUri();
    }

    public void waitUntilDone() {
        CompletableFuture.allOf(this.jobs.toArray(new CompletableFuture[0])).join();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            this.fileUploader.close();
        }
        catch (Exception e) {
            log.warn("File uploader close failed. Error: {}", (Object)e.toString());
        }
    }

    public void setUploadTask(UploadTask uploadTask) {
        this.uploadTask = uploadTask;
    }
}

