/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.ResourceFinder;
import com.oceanbase.tools.loaddump.resource.local.LocalResourceFinder;
import com.oceanbase.tools.loaddump.resource.remote.hdfs.HdfsResourceFinder;
import com.oceanbase.tools.loaddump.resource.remote.oss.OssResourceFinder;
import com.oceanbase.tools.loaddump.resource.remote.s3.S3ResourceFinder;

public class ResourceFinderFactory {
    public static ResourceFinder<Resource> createResourceFinder(LoadParameter parameter) {
        BaseStorageConfig config = parameter.getStorageConfig();
        if (config == null) {
            return new LocalResourceFinder(parameter);
        }
        if (StorageType.ALIYUN_OSS == config.getStorageType()) {
            return new OssResourceFinder(parameter);
        }
        if (StorageType.AMAZON_S3 == config.getStorageType()) {
            return new S3ResourceFinder(parameter);
        }
        if (StorageType.HADOOP_HDFS == config.getStorageType()) {
            return new HdfsResourceFinder(parameter);
        }
        throw new IllegalArgumentException("Unsupported storage type: " + (Object)((Object)config.getStorageType()));
    }
}

