/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.string;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.CodecUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvlFunction
extends AbstractBuiltinFunction {
    private static final Logger log = LoggerFactory.getLogger(NvlFunction.class);
    private static final int DEFAULT_HEX_LEN = 4;
    private static final String DEFAULT_HEX_PREFIX = "0x";
    private final String replacement;

    public NvlFunction(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public String getName() {
        return SqlFunctions.NVL.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null) {
            return null;
        }
        if (varargs[0] == null) {
            String replacer = this.replacement;
            if (replacer == null) {
                return null;
            }
            if ((replacer = replacer.trim().toLowerCase(Locale.getDefault())).length() == 4 && replacer.startsWith(DEFAULT_HEX_PREFIX)) {
                try {
                    return new String(CodecUtils.decodeHex(replacer.substring(2)));
                }
                catch (Exception e) {
                    log.error("Decode {} failed. Error: {}", (Object)replacer, (Object)ExceptionUtils.getRootCauseMessage(e));
                    return replacer;
                }
            }
            return this.replacement;
        }
        return varargs[0];
    }
}

