/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.generator;

import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObMySqlStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObOracleStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.generator.IDumpTaskGenerator;
import java.util.List;

public abstract class AbstractDumpTaskGenerator<T extends AbstractDumpTask>
implements IDumpTaskGenerator<T> {
    protected boolean oracleMode;
    protected ServerMode serverMode;
    protected DumpParameter parameter;
    protected ConnectionKey connectionKey;

    protected AbstractDumpTaskGenerator(DumpParameter parameter) {
        this.parameter = parameter;
        this.connectionKey = parameter.getConnectionKey();
        this.serverMode = parameter.getConnectionKey().getServerMode();
        this.oracleMode = parameter.getConnectionKey().getServerMode().isOracleMode();
    }

    @Override
    public List<T> generateDumpTask() {
        if (this.connectionKey.hasNoSysPrivileges() && this.serverMode.isPreviousV4()) {
            return this.generateDumpTaskForPublicCloud();
        }
        return this.generateDumpTaskForPrivateCloud();
    }

    protected AbstractStatementAssembler getBasicStatementAssembler() {
        return this.oracleMode ? new ObOracleStatementAssembler(this.parameter) : new ObMySqlStatementAssembler(this.parameter);
    }

    protected abstract List<T> generateDumpTaskForPublicCloud();

    protected abstract List<T> generateDumpTaskForPrivateCloud();
}

