/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.Hint;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.RowKey;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObMySqlStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObOracleStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.generator.AbstractDumpTaskGenerator;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTaskGenerator
extends AbstractDumpTaskGenerator<RecordDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTaskGenerator.class);
    protected long pageSize;
    protected boolean snapshot;
    protected boolean weakRead;
    protected boolean distinct;
    protected boolean enableHiddenPk;
    protected long dataVersion;
    protected int parallelMacros;
    protected Database database;
    protected Set<String> specifiedParts;
    protected String flashbackScn;
    protected String flashbackTimestamp;
    protected MetadataProvider metadataProvider;
    protected Map<String, TableEntryInfo> tableEntryInfoMap;
    private final Cache<String, PreparedStatement> pstmtCache = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(8192L).softValues().concurrencyLevel(256).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(n -> {
        JdbcUtils.close((AutoCloseable)n.getValue());
        log.debug("Remove the cached prepared statement as the key has been marked: {}", (Object)n.getCause());
    }).build();

    public RecordDumpTaskGenerator(DumpParameter parameter) {
        super(parameter);
        this.distinct = parameter.isDistinct();
        this.snapshot = parameter.isSnapshot();
        this.pageSize = parameter.getPageSize();
        this.weakRead = parameter.isWeakRead();
        this.enableHiddenPk = parameter.isEnableHiddenPk();
        this.database = parameter.getDatabase();
        this.flashbackScn = parameter.getFlashbackScn();
        this.specifiedParts = parameter.getPartitions();
        this.flashbackTimestamp = parameter.getFlashbackTimestamp();
        this.parallelMacros = Math.min(parameter.getParallelMacros(), 50);
    }

    @Override
    protected List<RecordDumpTask> generateDumpTaskForPublicCloud() {
        if (StringUtils.isNotEmpty(this.parameter.getQuerySql()) || this.parameter.isLogicalDatabase()) {
            String tableName = CollectionUtils.isEmpty(this.database.getTableNames()) ? "CUSTOM_SQL" : this.database.getTableNames().get(0);
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, this.getBasicStatementAssembler())});
        }
        Set<Map.Entry<String, TableEntryInfo>> tableEntryInfoMapCopies = this.tableEntryInfoMap.entrySet();
        ArrayList<RecordDumpTask> dumpTasks = new ArrayList<RecordDumpTask>(tableEntryInfoMapCopies.size());
        Iterator iter = tableEntryInfoMapCopies.iterator();
        while (iter.hasNext()) {
            String tableName = (String)((Map.Entry)iter.next()).getKey();
            if (!this.tableEntryInfoMap.get(tableName).isEmptyTable()) continue;
            dumpTasks.add(new RecordDumpTask(true, tableName, this.getBasicStatementAssembler()));
            iter.remove();
        }
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("generate-dump-tasks-in-public-cloud-");
        for (Map.Entry entry : tableEntryInfoMapCopies) {
            String tableName = (String)entry.getKey();
            TableEntryInfo tableEntryInfo = (TableEntryInfo)entry.getValue();
            AtomicInteger group = new AtomicInteger(0);
            List<String> partNames = this.filterSpecifiedPartitionNames(tableName, tableEntryInfo.getPartNames());
            boolean isPartNameNotExists = CollectionUtils.isEmpty(partNames);
            int size = isPartNameNotExists ? 0 : partNames.size() - 1;
            for (int i = 0; i <= size; ++i) {
                String partName = isPartNameNotExists ? null : partNames.get(i);
                template.submit(() -> {
                    List<TableRangeInfo> tableRangeInfoList = this.splitTableRows(tableName, partName);
                    ArrayList<RecordDumpTask> tempTasks = new ArrayList<RecordDumpTask>(tableRangeInfoList.size());
                    for (TableRangeInfo tableRangeInfo : tableRangeInfoList) {
                        if (this.oracleMode) {
                            tempTasks.add(new RecordDumpTask(tableName, group.getAndIncrement(), (AbstractStatementAssembler)new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                            continue;
                        }
                        tempTasks.add(new RecordDumpTask(tableName, group.getAndIncrement(), (AbstractStatementAssembler)new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                    }
                    return tempTasks;
                });
            }
        }
        dumpTasks.addAll(template.waitForResult().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return dumpTasks;
    }

    @Override
    protected List<RecordDumpTask> generateDumpTaskForPrivateCloud() {
        if (StringUtils.isNotEmpty(this.parameter.getQuerySql())) {
            String tableName = CollectionUtils.isEmpty(this.database.getTableNames()) ? "CUSTOM_SQL" : this.database.getTableNames().get(0);
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, this.getBasicStatementAssembler())});
        }
        Set<Map.Entry<String, TableEntryInfo>> tableEntryInfoMapCopies = this.tableEntryInfoMap.entrySet();
        ArrayList<RecordDumpTask> dumpTasks = new ArrayList<RecordDumpTask>(tableEntryInfoMapCopies.size());
        Iterator iter = tableEntryInfoMapCopies.iterator();
        while (iter.hasNext()) {
            String tableName = (String)((Map.Entry)iter.next()).getKey();
            if (!this.tableEntryInfoMap.get(tableName).isEmptyTable()) continue;
            dumpTasks.add(new RecordDumpTask(true, tableName, this.getBasicStatementAssembler()));
            iter.remove();
        }
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("generate-dump-tasks-in-private-cloud-");
        for (Map.Entry entry : tableEntryInfoMapCopies) {
            String tableName = (String)entry.getKey();
            TableEntryInfo tableEntryInfo = (TableEntryInfo)entry.getValue();
            AtomicInteger group = new AtomicInteger(1);
            List<String> partNames = this.filterSpecifiedPartitionNames(tableName, tableEntryInfo.getPartNames());
            boolean isPartNameNotExists = CollectionUtils.isEmpty(partNames);
            int size = isPartNameNotExists ? 0 : partNames.size() - 1;
            for (int i = 0; i <= size; ++i) {
                String partName = isPartNameNotExists ? null : partNames.get(i);
                template.submit(() -> {
                    if (isPreviousV4 && this.dataVersion > 0L && tableEntryInfo.getTableEntry() != null) {
                        return this.generateDumpTaskForSnapshot(tableName);
                    }
                    List<TableRangeInfo> taskRangeInfoList = this.splitTableRows(tableName, partName);
                    ArrayList<RecordDumpTask> tempTasks = new ArrayList<RecordDumpTask>(taskRangeInfoList.size());
                    for (TableRangeInfo tableRangeInfo : taskRangeInfoList) {
                        if (this.oracleMode) {
                            tempTasks.add(new RecordDumpTask(tableName, group.getAndIncrement(), (AbstractStatementAssembler)new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                            continue;
                        }
                        tempTasks.add(new RecordDumpTask(tableName, group.getAndIncrement(), (AbstractStatementAssembler)new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                    }
                    return tempTasks;
                });
            }
        }
        dumpTasks.addAll(template.waitForResult().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return dumpTasks;
    }

    private List<RecordDumpTask> generateDumpTaskForSnapshot(String tableName) throws Exception {
        List<RowKey> validRowKeys;
        TableEntryInfo tableEntryInfo = this.tableEntryInfoMap.get(tableName);
        TableEntry tableEntry = tableEntryInfo.getTableEntry();
        Long tableId = tableEntry.getTableId();
        String tenant = tableEntry.getTenantName();
        List<RowKey> rowKeys = this.metadataProvider.queryRowKeys(this.serverMode, tenant, tableId);
        if (CollectionUtils.isEmpty(rowKeys)) {
            log.warn("Row keys are not exists. Maybe some errors occurred during query row keys. Use select /* +frozen_version({}) */ instead.", (Object)this.dataVersion);
        }
        if (CollectionUtils.isEmpty(validRowKeys = rowKeys.stream().filter(e -> !Constants.HIDDEN_KEYS.contains(e.getColumn())).collect(Collectors.toList()))) {
            log.warn("No valid row keys can be used. Maybe the non-partitioned table: \"{}\" has no primary key. Use select /* +frozen_version({}) */ instead.", (Object)tableName, (Object)this.dataVersion);
            if (this.oracleMode) {
                return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, new ObOracleStatementAssembler(new TableRangeInfo(tableName), this.parameter, this.dataVersion))});
            }
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, new ObMySqlStatementAssembler(new TableRangeInfo(tableName), this.parameter, this.dataVersion))});
        }
        Map<Long, List<String>> macroRangeMap = this.metadataProvider.queryMacroRangeMap(tableEntryInfo.getLeaderMap(), tableId, this.dataVersion);
        boolean nonPartitioned = tableEntry.isNonPartitionTable();
        Map partIdNameMap = tableEntry.getPartIdNameMap();
        HashMap<String, List<String>> macroRangeListMap = new HashMap<String, List<String>>(64);
        for (Long partitionId : macroRangeMap.keySet()) {
            if (nonPartitioned) {
                macroRangeListMap.putIfAbsent(null, macroRangeMap.get(partitionId));
                continue;
            }
            for (String partName : (Set)partIdNameMap.get(partitionId)) {
                if (!this.isPartitionInclude(partName)) continue;
                macroRangeListMap.putIfAbsent(partName, new ArrayList());
                ((List)macroRangeListMap.get(partName)).addAll((Collection)macroRangeMap.get(partitionId));
            }
        }
        if (MapUtils.isEmpty(macroRangeListMap)) {
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(true, tableName, this.getBasicStatementAssembler())});
        }
        int macroTaskCount = 1;
        String rowKeyString = this.getRowKeyString(validRowKeys);
        ArrayList<RecordDumpTask> tasks = new ArrayList<RecordDumpTask>(1024);
        for (Map.Entry entry : macroRangeListMap.entrySet()) {
            List macroGroups = Lists.partition((List)((List)entry.getValue()), (int)this.parallelMacros);
            for (List macroGroup : macroGroups) {
                List<Pair<RangeKey[], RangeKey[]>> macroRangeList = this.parseMacroRange(macroGroup, rowKeys, validRowKeys.size());
                TableRangeInfo tableRangeInfo = new TableRangeInfo(tableName, macroRangeList, rowKeyString, (String)entry.getKey());
                if (this.oracleMode) {
                    tasks.add(new RecordDumpTask(tableName, macroTaskCount, (AbstractStatementAssembler)new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                } else {
                    tasks.add(new RecordDumpTask(tableName, macroTaskCount, (AbstractStatementAssembler)new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                }
                ++macroTaskCount;
            }
        }
        return tasks;
    }

    protected List<TableRangeInfo> splitTableRows(String tableName, String partName) throws Exception {
        String partitionedFlag;
        boolean isPartNameNotExists = StringUtils.isBlank(partName);
        String string = partitionedFlag = isPartNameNotExists ? "non-partitioned table" : "partitioned table";
        if (CollectionUtils.isEmpty(this.tableEntryInfoMap.get(tableName).getPrimaryNames())) {
            if (isPartNameNotExists) {
                log.info("Split rows for {}(without primary key): \"{}\" success. Ranges: 1", (Object)partitionedFlag, (Object)tableName);
                return Lists.newArrayList((Object[])new TableRangeInfo[]{new TableRangeInfo(tableName)});
            }
            log.info("Split rows for {}(without primary key): \"{}\" partition: \"{}\" success. Ranges: 1", new Object[]{partitionedFlag, tableName, partName});
            return Lists.newArrayList((Object[])new TableRangeInfo[]{new TableRangeInfo(tableName, partName)});
        }
        try {
            List<TableRangeInfo> bounds = null;
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (isPartNameNotExists) {
                bounds = this.queryBounds(tableName, null);
                log.info("Split rows for {}(with primary key): \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, bounds.size(), stopwatch});
            } else {
                bounds = this.queryBounds(tableName, partName);
                log.info("Split rows for {}(with primary key): \"{}\" partition: \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, partName, bounds.size(), stopwatch});
            }
            return bounds;
        }
        catch (Exception e) {
            log.error("Split rows for {}(with primary key): \"{}\" failed. Reason: {}", new Object[]{partitionedFlag, tableName, ExceptionUtils.getRootCauseMessage(e)});
            throw new IllegalStateException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private List<TableRangeInfo> queryBounds(String tableName, String partName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 35[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement cachedPreparedStatement(Connection conn, String schemaTable, String partName, String primaryCols, String descPriCols, RangeKey[] preVals) throws Exception {
        ArrayList<String> keys = new ArrayList<String>(6);
        keys.add(this.oracleMode ? "o" : "m");
        keys.add(schemaTable);
        keys.add(StringUtils.isNotBlank(partName) ? "p-" + partName : "np");
        keys.add(primaryCols);
        keys.add(StringUtils.isNotBlank(descPriCols) ? "d" : "a");
        keys.add(preVals == null ? "nc" : "c");
        String key = String.join((CharSequence)"-", keys);
        return (PreparedStatement)this.pstmtCache.get((Object)key, () -> {
            log.debug("Prepare cache statement for key: {}", (Object)key);
            CharSequence sql = this.oracleMode ? this.buildOracleSelectBoundPattern(schemaTable, partName, primaryCols, descPriCols, preVals) : this.buildMysqlSelectBoundPattern(schemaTable, partName, primaryCols, preVals);
            PreparedStatement pstmt = conn.prepareStatement(sql.toString(), 1003, 1007);
            if (this.serverMode.isOracleMode()) {
                pstmt.setFetchSize(this.parameter.getFetchSize());
            } else {
                pstmt.setFetchSize(Integer.MIN_VALUE);
            }
            return pstmt;
        });
    }

    private List<String> filterSpecifiedPartitionNames(String tableName, List<String> partNames) {
        if (CollectionUtils.isEmpty(this.getSpecifiedParts())) {
            return partNames;
        }
        ArrayList specifiedPartNames = Lists.newArrayList(this.getSpecifiedParts());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(partNames), (String)"Partitions: %s are not exists of a non-partitioned table: \"%s\"", (Object)specifiedPartNames, (Object)tableName);
        partNames.retainAll(specifiedPartNames);
        if (partNames.size() != specifiedPartNames.size()) {
            specifiedPartNames.removeAll(partNames);
            throw new IllegalArgumentException("Partition: [" + org.apache.commons.lang3.StringUtils.join((Iterable)specifiedPartNames, (String)",") + "] are not exists");
        }
        return partNames;
    }

    private boolean isPartitionInclude(String partitionName) {
        Set<String> specifiedPartNames = this.getSpecifiedParts();
        if (CollectionUtils.isEmpty(specifiedPartNames)) {
            return true;
        }
        return specifiedPartNames.contains(partitionName);
    }

    private String getRowKeyString(List<RowKey> rowKeys) {
        if (CollectionUtils.isEmpty(rowKeys)) {
            return null;
        }
        return rowKeys.stream().filter(k -> !Constants.HIDDEN_KEYS.contains(k.getColumn())).map(k -> this.serverMode.wrapName(k.getColumn())).collect(Collectors.joining(","));
    }

    private CharSequence buildMysqlSelectBoundPattern(String schemaTable, String partName, String primaryCols, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("select ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.dataVersion > 0L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.dataVersion));
        }
        if (this.enableHiddenPk && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (hints.size() > 0) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(" from ").append(schemaTable);
        if (StringUtils.isNotEmpty(partName)) {
            sql.append("partition(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (!this.snapshot && !this.serverMode.isPreviousV2270() && StringUtils.isNotBlank(this.getFlashbackScn())) {
            sql.append(" as of snapshot ").append(this.getFlashbackScn());
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            sql.append(" where ( ").append(primaryCols).append(") > ( ").append(prePlaceHolders).append(" ) ");
        }
        return sql.append(" order by ").append(primaryCols).append(" limit ").append(this.pageSize - 1L).append(",").append(" 1 ");
    }

    private CharSequence buildOracleSelectBoundPattern(String schemaTable, String partName, String primaryCols, String descPrimaryCols, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("SELECT ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.dataVersion > 0L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.dataVersion));
        }
        if (this.enableHiddenPk && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (hints.size() > 0) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(", ROWNUM RN FROM ").append(schemaTable);
        if (StringUtils.isNotEmpty(partName)) {
            sql.append("PARTITION(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (!this.snapshot && !this.serverMode.isPreviousV2270()) {
            if (StringUtils.isNotBlank(this.getFlashbackScn())) {
                sql.append(" AS OF SCN ").append(this.getFlashbackScn());
            } else if (StringUtils.isNotBlank(this.flashbackTimestamp)) {
                sql.append(" AS OF TIMESTAMP TO_TIMESTAMP('").append(this.flashbackTimestamp).append("','YYYY-MM-DD HH24:MI:SS')");
            }
        }
        if (this.serverMode.isPrevious("2.2.52")) {
            sql.append(" WHERE ");
            if (preVals != null) {
                String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
                sql.append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(") AND ");
            }
            sql.append(" ROWNUM<=").append(this.pageSize).append(" ORDER BY ").append(descPrimaryCols);
            return "SELECT " + primaryCols + " FROM (" + sql + ") A WHERE ROWNUM<=1 ORDER BY A.RN";
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            sql.append(" WHERE ").append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(")");
        }
        sql.append(" ORDER BY ").append(primaryCols).append(" OFFSET ").append(this.pageSize - 1L).append(" ROWS FETCH NEXT 1 ROWS ONLY");
        return sql;
    }

    protected List<Pair<RangeKey[], RangeKey[]>> parseMacroRange(List<String> macroRanges, List<RowKey> rowKeys, int validRowKeySize) {
        if (CollectionUtils.isEmpty(macroRanges)) {
            return null;
        }
        ArrayList<Pair<RangeKey[], RangeKey[]>> conditions = new ArrayList<Pair<RangeKey[], RangeKey[]>>(2);
        for (String range : macroRanges) {
            if (StringUtils.isBlank(range) || range.length() < 2) continue;
            range = range.trim();
            String[] ranges = range.substring(1, range.lastIndexOf(93)).split(" ; ");
            RangeKey[] startValues = new RangeKey[]{};
            String left = ranges[0];
            if (!"MIN".equals(left)) {
                startValues = new RangeKey[validRowKeySize];
                String[] macros = left.split(",");
                for (int i = 0; i < macros.length; ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    startValues[i] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macros[i], "TO_TIMESTAMP(?)") : new RangeKey(macros[i]);
                }
            }
            RangeKey[] endValues = new RangeKey[]{};
            String right = ranges[1];
            if (!"MAX".equals(right)) {
                endValues = new RangeKey[validRowKeySize];
                String[] macros = right.split(",");
                for (int i = 0; i < macros.length; ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    endValues[i] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macros[i], "TO_TIMESTAMP(?)") : new RangeKey(macros[i]);
                }
            }
            if (!ArrayUtils.isNotEmpty(startValues) && !ArrayUtils.isNotEmpty(endValues)) continue;
            conditions.add(new Pair<RangeKey[], RangeKey[]>(startValues, endValues));
        }
        return conditions;
    }

    public void setDataVersion(long dataVersion) {
        this.dataVersion = dataVersion;
    }

    public Set<String> getSpecifiedParts() {
        return this.specifiedParts;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void setTableEntryInfoMap(Map<String, TableEntryInfo> tableEntryInfoMap) {
        this.tableEntryInfoMap = tableEntryInfoMap;
    }

    private /* synthetic */ String lambda$queryBounds$5(String e) {
        return this.serverMode.wrapName(e) + " desc ";
    }

    private /* synthetic */ String lambda$queryBounds$4(String e) {
        return this.serverMode.wrapName(e);
    }
}

