/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlNoSysSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleNoSysSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleSchemaDumpTask;
import com.oceanbase.tools.loaddump.generator.AbstractDumpTaskGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaDumpTaskGenerator
extends AbstractDumpTaskGenerator<AbstractSchemaDumpTask> {
    public SchemaDumpTaskGenerator(DumpParameter parameter) {
        super(parameter);
    }

    @Override
    protected List<AbstractSchemaDumpTask> generateDumpTaskForPublicCloud() {
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        ArrayList<AbstractSchemaDumpTask> ddlDumpTasks = new ArrayList<AbstractSchemaDumpTask>(whiteListMap.size());
        for (Map.Entry<ObjectType, Set<String>> entry : whiteListMap.entrySet()) {
            ObjectType objectType = entry.getKey();
            List partitionObjectNames = Lists.partition((List)Lists.newArrayList((Iterable)entry.getValue()), (int)128);
            for (List batch : partitionObjectNames) {
                HashMap<ObjectType, HashSet> batchWhiteListMap = new HashMap<ObjectType, HashSet>(1);
                batchWhiteListMap.put(objectType, Sets.newHashSet((Iterable)batch));
                AbstractSchemaDumpTask dumpTask = this.oracleMode ? new ObOracleNoSysSchemaDumpTask() : new ObMysqlNoSysSchemaDumpTask();
                dumpTask.setObjectType(objectType.getName());
                dumpTask.setSchemaless(this.parameter.isSchemaless());
                dumpTask.setWithExtra(this.parameter.isWithExtra());
                dumpTask.getWhiteListMap().putAll(batchWhiteListMap);
                dumpTask.getBlackListMap().putAll(this.parameter.getBlackListMap());
                ddlDumpTasks.add(dumpTask);
            }
        }
        return ddlDumpTasks;
    }

    @Override
    protected List<AbstractSchemaDumpTask> generateDumpTaskForPrivateCloud() {
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        ArrayList<AbstractSchemaDumpTask> ddlDumpTasks = new ArrayList<AbstractSchemaDumpTask>(whiteListMap.size());
        for (Map.Entry<ObjectType, Set<String>> entry : whiteListMap.entrySet()) {
            ObjectType objectType = entry.getKey();
            List partitionObjectNames = Lists.partition((List)Lists.newArrayList((Iterable)entry.getValue()), (int)128);
            for (List batch : partitionObjectNames) {
                HashMap<ObjectType, HashSet> batchWhiteListMap = new HashMap<ObjectType, HashSet>(16);
                batchWhiteListMap.put(objectType, Sets.newHashSet((Iterable)batch));
                AbstractSchemaDumpTask dumpTask = this.oracleMode ? new ObOracleSchemaDumpTask() : new ObMysqlSchemaDumpTask();
                dumpTask.setObjectType(objectType.getName());
                dumpTask.setSchemaless(this.parameter.isSchemaless());
                dumpTask.setWithExtra(this.parameter.isWithExtra());
                dumpTask.getWhiteListMap().putAll(batchWhiteListMap);
                dumpTask.getBlackListMap().putAll(this.parameter.getBlackListMap());
                ddlDumpTasks.add(dumpTask);
            }
        }
        return ddlDumpTasks;
    }
}

