/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.MetricAttribute;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.tablefmt.Table;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.Closeable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduledReporter
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduledReporter.class);
    private static final AtomicInteger FACTORY_ID = new AtomicInteger();
    private final MetricRegistry registry;
    private final ScheduledExecutorService executor;
    private final boolean shutdownExecutorOnStop;
    private final Set<MetricAttribute> disabledMetricAttributes;
    private final long durationFactor;
    private final String durationUnit;
    private final long rateFactor;
    private final String rateUnit;
    private ScheduledFuture<?> scheduledFuture;

    protected AbstractScheduledReporter(MetricRegistry registry, String name, TimeUnit rateUnit, TimeUnit durationUnit) {
        this(registry, name, rateUnit, durationUnit, AbstractScheduledReporter.createDefaultExecutor(name));
    }

    protected AbstractScheduledReporter(MetricRegistry registry, String name, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor) {
        this(registry, name, rateUnit, durationUnit, executor, true);
    }

    protected AbstractScheduledReporter(MetricRegistry registry, String name, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor, boolean shutdownExecutorOnStop) {
        this(registry, name, rateUnit, durationUnit, executor, shutdownExecutorOnStop, Collections.emptySet());
    }

    protected AbstractScheduledReporter(MetricRegistry registry, String name, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        this.registry = registry;
        this.executor = executor == null ? AbstractScheduledReporter.createDefaultExecutor(name) : executor;
        this.shutdownExecutorOnStop = shutdownExecutorOnStop;
        this.rateFactor = rateUnit.toSeconds(1L);
        this.rateUnit = this.calculateRateUnit(rateUnit);
        this.durationFactor = durationUnit.toNanos(1L);
        this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
        this.disabledMetricAttributes = disabledMetricAttributes != null ? disabledMetricAttributes : Collections.emptySet();
    }

    private static ScheduledExecutorService createDefaultExecutor(String name) {
        return new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(name + '-' + FACTORY_ID.incrementAndGet()));
    }

    public void start(long period, TimeUnit unit) {
        this.start(period, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(long initialDelay, long period, TimeUnit unit, Runnable runnable) {
        AbstractScheduledReporter abstractScheduledReporter = this;
        synchronized (abstractScheduledReporter) {
            if (this.scheduledFuture != null) {
                throw new IllegalArgumentException("Reporter already started");
            }
            this.scheduledFuture = this.executor.scheduleAtFixedRate(runnable, initialDelay, period, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long initialDelay, long period, TimeUnit unit) {
        AbstractScheduledReporter abstractScheduledReporter = this;
        synchronized (abstractScheduledReporter) {
            this.start(initialDelay, period, unit, () -> {
                try {
                    this.report();
                }
                catch (Throwable ex) {
                    log.error("Exception thrown from {}#report. Exception was suppressed.", (Object)this.getClass().getSimpleName(), (Object)ex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block10: {
            if (this.shutdownExecutorOnStop) {
                this.executor.shutdown();
                try {
                    if (this.executor.awaitTermination(1L, TimeUnit.SECONDS)) break block10;
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        log.error(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate");
                    }
                }
                catch (InterruptedException ie) {
                    this.executor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            } else {
                AbstractScheduledReporter abstractScheduledReporter = this;
                synchronized (abstractScheduledReporter) {
                    if (this.scheduledFuture == null) {
                        return;
                    }
                    if (this.scheduledFuture.isCancelled()) {
                        return;
                    }
                    this.scheduledFuture.cancel(false);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        AbstractScheduledReporter abstractScheduledReporter = this;
        synchronized (abstractScheduledReporter) {
            this.report(this.registry.getMeters());
        }
    }

    public abstract void report(SortedMap<String, Meter> var1);

    protected void logMeter(StringBuilder b, String name, Meter meter) {
        b.append("\n\n").append(name).append("\n");
        String[] buffers = meter.getBuffer();
        Table table = new Table(4);
        table.setColumnWidth(0, 10, 20);
        table.setColumnWidth(1, 30, 50);
        table.setColumnWidth(2, 30, 50);
        int minWidth = (JvmArgs.isDebugable ? 30 : 15) * buffers.length;
        table.setColumnWidth(3, minWidth + 5, minWidth + 25);
        String buffer = Arrays.stream(buffers).filter(e -> StringUtils.isNotBlank((CharSequence)e)).collect(Collectors.joining(", "));
        table.addCell(" Dimension \\ Metric ");
        table.addCell("Tps");
        table.addCell("Throughput");
        table.addCell("Buffer");
        table.addCell("1.sec.avg");
        table.addCell(this.convertRate(meter.getMeanTpsRate()) + " Records/sec");
        table.addCell(SqlUtils.convertUnit(this.convertRate(meter.getMeanThroughputRate())) + "/sec");
        table.addCell(buffer);
        table.addCell("1.min.avg");
        table.addCell(this.convertRate(meter.getOneMinuteTpsRate()) + " Records/sec");
        table.addCell(SqlUtils.convertUnit(this.convertRate(meter.getOneMinuteThroughputRate())) + "/sec");
        table.addCell(buffer);
        table.addCell("Total");
        table.addCell(meter.getTps() + " Records");
        table.addCell(SqlUtils.convertUnit(meter.getThroughput()));
        table.addCell(buffer);
        b.append((CharSequence)table.render());
    }

    protected abstract void outputTo(String var1);

    protected String getRateUnit() {
        return this.rateUnit;
    }

    protected String getDurationUnit() {
        return this.durationUnit;
    }

    protected double convertDuration(double duration) {
        return new BigDecimal(duration / (double)this.durationFactor).setScale(2, 4).doubleValue();
    }

    protected double convertRate(double rate) {
        return new BigDecimal(rate * (double)this.rateFactor).setScale(2, 4).doubleValue();
    }

    protected boolean isShutdownExecutorOnStop() {
        return this.shutdownExecutorOnStop;
    }

    protected Set<MetricAttribute> getDisabledMetricAttributes() {
        return this.disabledMetricAttributes;
    }

    private String calculateRateUnit(TimeUnit unit) {
        String s = unit.toString().toLowerCase(Locale.US);
        return s.substring(0, s.length() - 1);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

