/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import com.oceanbase.tools.loaddump.metrics.Clock;
import com.oceanbase.tools.loaddump.metrics.EWMA;
import com.oceanbase.tools.loaddump.metrics.MovingAverages;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ExponentialMovingAverages
implements MovingAverages {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final EWMA m1TpsRate = EWMA.oneMinuteEWMA();
    private final EWMA m1ThroughputRate = EWMA.oneMinuteEWMA();
    private final AtomicLong lastTick;
    private final Clock clock;

    public ExponentialMovingAverages() {
        this(Clock.defaultClock());
    }

    public ExponentialMovingAverages(Clock clock) {
        this.clock = clock;
        this.lastTick = new AtomicLong(this.clock.getTick());
    }

    @Override
    public void updateTps(long n) {
        this.m1TpsRate.update(n);
    }

    @Override
    public void updateThroughput(long n) {
        this.m1ThroughputRate.update(n);
    }

    @Override
    public void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m1TpsRate.tick();
                this.m1ThroughputRate.tick();
            }
        }
    }

    @Override
    public double getTpsM1Rate() {
        return this.m1TpsRate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public double getThroughputM1Rate() {
        return this.m1ThroughputRate.getRate(TimeUnit.SECONDS);
    }
}

