/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.mybatis.type.custom.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimeToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -2881706743781099387L;
    private static final String DEFAULT_ZERO_TIME_VALUE = "00:00:00";
    private DateTimeFormatter timeValueFormatter;
    private boolean preserveZeroDatetime;
    private int precision;

    public TimeToStringTypeHandler(String timeValuePattern, int precision, boolean preserveZeroDatetime) {
        this.precision = precision;
        this.preserveZeroDatetime = preserveZeroDatetime;
        if (StringUtils.isNotBlank(timeValuePattern)) {
            this.timeValueFormatter = DateTimeFormatter.ofPattern(timeValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnName));
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime ? DEFAULT_ZERO_TIME_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        try {
            return this.translateTo(rs.getTimestamp(columnIndex));
        }
        catch (Throwable t) {
            if (t.getMessage().contains("nanos > 999999999 or < 0")) {
                return this.translateTo(rs.getTime(columnIndex));
            }
            throw t;
        }
    }

    private String translateTo(Date value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return value.toString();
        }
        LocalDateTime ldt = ((Timestamp)value).toLocalDateTime();
        return this.timeValueFormatter == null ? this.localTimeToString(ldt) : this.timeValueFormatter.format(ldt.toLocalTime());
    }

    private String localTimeToString(LocalDateTime ldt) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(Constants.DEFAULT_TIME_FORMATTER.format(ldt));
        if (this.precision == 0) {
            return sb.toString();
        }
        String nanoStr = super.formatNanoTime(ldt.getNano());
        sb.append('.').append(nanoStr);
        for (int i = this.precision - nanoStr.length(); i > 0; --i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public TimeToStringTypeHandler() {
    }
}

