/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.exception.ParseFailureException;
import com.oceanbase.tools.loaddump.parser.AbstractParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordParser
extends AbstractParser<Record> {
    protected boolean closed;
    protected final DefaultRecordIterator defaultRecordIterator = new DefaultRecordIterator(this);

    public abstract Record nextRecord() throws IOException;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.defaultRecordIterator;
    }

    public static class DefaultRecordIterator
    implements Iterator<Record> {
        private static final Logger log = LoggerFactory.getLogger(DefaultRecordIterator.class);
        private Record current;
        private final AbstractRecordParser parser;

        public DefaultRecordIterator(AbstractRecordParser parser) {
            Preconditions.checkArgument((parser != null ? 1 : 0) != 0, (Object)"Input record parser is null");
            this.parser = parser;
        }

        @Override
        public boolean hasNext() {
            if (this.parser.isClosed()) {
                return false;
            }
            if (this.current == null) {
                this.current = this.getNextRecord();
            }
            return this.current != null;
        }

        @Override
        public Record next() {
            if (this.parser.isClosed()) {
                throw new NoSuchElementException("The record parser: [\"" + this.parser.getClass().getSimpleName() + "\"] is already closed");
            }
            Record next = this.current;
            this.current = null;
            if (next == null && (next = this.getNextRecord()) == null) {
                throw new NoSuchElementException("No more available records");
            }
            return next;
        }

        private Record getNextRecord() {
            try {
                return this.parser.nextRecord();
            }
            catch (IOException e) {
                throw new ParseFailureException("Get next record failed ", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is unsupported");
        }
    }
}

