/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.parser.record.Token;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvLexer;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvRecordParser
extends AbstractRowOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(CsvRecordParser.class);
    private final CsvFormat format;
    private final Map<String, Integer> headerMap;
    private final List<String> headerNames;
    private final CsvLexer lexer;
    private final List<String> recordList = new ArrayList<String>(128);
    private final long characterOffset;
    private long recordNumber;
    private final Token reusableToken = new Token();

    private CsvRecordParser(Reader reader, CsvFormat format) throws IOException {
        this(reader, format, 0L, 1L);
    }

    private CsvRecordParser(Reader reader, CsvFormat format, long characterOffset, long recordNumber) throws IOException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Input reader is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Input format is null");
        this.lexer = new CsvLexer(format, new ExtendedBufferedReader(reader));
        this.format = format;
        this.recordNumber = recordNumber - 1L;
        this.characterOffset = characterOffset;
        Headers headers = this.createHeaders();
        this.headerMap = headers.headerMap;
        this.headerNames = headers.headerNames;
    }

    public static CsvRecordParser parse(File file, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Input format is null");
        return new CsvRecordParser(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset), format);
    }

    public static CsvRecordParser parse(InputStream is, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CsvRecordParser.parse(new InputStreamReader(is, charset), format);
    }

    public static CsvRecordParser parse(Path path, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Input format is null");
        return CsvRecordParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, format);
    }

    public static CsvRecordParser parse(Reader reader, CsvFormat format) throws IOException {
        return new CsvRecordParser(reader, format);
    }

    public static CsvRecordParser parse(String string, CsvFormat format) throws IOException {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Input format is null");
        return new CsvRecordParser(new StringReader(string), format);
    }

    public static CsvRecordParser parse(URL url, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Input format is null");
        return new CsvRecordParser(new InputStreamReader(url.openStream(), charset), format);
    }

    private void addRecordValue(boolean lastRecord) {
        String inputClean;
        String input = this.reusableToken.content.toString();
        String string = inputClean = this.format.getTrim() ? input.trim() : input;
        if (lastRecord && inputClean.isEmpty() && this.format.getTrailingDelimiter()) {
            return;
        }
        String nullString = this.format.getNullString();
        String emptyString = this.format.getEmptyString();
        String emptyReplacer = this.format.getEmptyReplacer();
        if (StringUtils.equals(nullString, inputClean)) {
            this.recordList.add(null);
        } else if (StringUtils.equals(emptyString, inputClean)) {
            this.recordList.add(emptyReplacer == null ? "" : emptyReplacer);
        } else if (emptyReplacer != null && "".equals(inputClean)) {
            this.recordList.add(emptyReplacer);
        } else {
            this.recordList.add(inputClean);
        }
    }

    private Map<String, Integer> createEmptyHeaderMap() {
        return this.format.getIgnoreHeaderCase() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
    }

    private Headers createHeaders() throws IOException {
        ArrayList<String> headerNames = new ArrayList<String>();
        Map<String, Integer> hdrMap = this.createEmptyHeaderMap();
        Object[] formatHeader = this.format.getHeader();
        Record nextRecord = null;
        if (this.format.getSkipHeaderRecord()) {
            nextRecord = this.nextRecord();
        }
        if (ArrayUtils.isEmpty(formatHeader)) {
            if (this.format.getSkipHeaderRecord()) {
                if (nextRecord != null) {
                    String[] headerRecord = nextRecord.getValues().toArray(new String[0]);
                    for (int i = 0; i < headerRecord.length; ++i) {
                        String header = headerRecord[i];
                        if (header == null) continue;
                        headerNames.add(header);
                        hdrMap.put(header, i);
                    }
                } else {
                    log.warn("The --skip-header is sepcified, but the CSV file may not contain the headers");
                }
            } else {
                log.warn("CSVFormat not contains the header names and the --skip-header is unsepcified");
            }
            return new Headers(hdrMap, Lists.newArrayList(headerNames));
        }
        Object[] headerRecord = formatHeader;
        for (int i = 0; i < headerRecord.length; ++i) {
            Object header = headerRecord[i];
            if (header != null && hdrMap.containsKey(header)) {
                boolean emptyHeader = StringUtils.isBlank((CharSequence)header);
                if (emptyHeader && !this.format.getAllowMissingColumnNames()) {
                    String headerString = Arrays.toString(headerRecord);
                    throw new IllegalArgumentException("A header name is missing in " + headerString);
                }
                if (!emptyHeader && !this.format.getAllowDuplicateHeaderNames()) {
                    String headerString = Arrays.toString(headerRecord);
                    throw new IllegalArgumentException("Duplicate header: \"" + (String)header + "\" in " + headerString);
                }
            }
            if (header == null) continue;
            headerNames.add((String)header);
            hdrMap.put((String)header, i);
        }
        return new Headers(hdrMap, headerNames);
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public String getFirstEndOfLine() {
        return this.lexer.getFirstEol();
    }

    public Map<String, Integer> getHeaderMap() {
        if (this.headerMap == null) {
            return null;
        }
        Map<String, Integer> map = this.createEmptyHeaderMap();
        map.putAll(this.headerMap);
        return map;
    }

    Map<String, Integer> getHeaderMapRaw() {
        return this.headerMap;
    }

    public List<String> getHeaderNames() {
        return this.headerNames;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public long getCurrentPosition() {
        return this.lexer.getCharacterPosition();
    }

    public boolean moveToNextRecord() {
        return this.lexer.moveToNextRecord(this.format);
    }

    @Override
    public void close() throws IOException {
        if (this.lexer != null) {
            this.lexer.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    @Override
    public Record nextRecord() throws IOException {
        Record record = null;
        this.recordList.clear();
        long startCharPosition = this.lexer.getCharacterPosition() + this.characterOffset;
        block7: do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.addRecordValue(false);
                    break;
                }
                case EOR: {
                    this.addRecordValue(true);
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) continue block7;
                    this.addRecordValue(true);
                    break;
                }
                case INVALID: {
                    throw new IOException("(Invalid Token. Line: [" + this.getCurrentLineNumber() + ", " + this.getCurrentPosition() + "]");
                }
                case COMMENT: {
                    this.reusableToken.type = Token.Type.TOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Token type: " + (Object)((Object)this.reusableToken.type));
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.recordList.isEmpty()) {
            record = new Record(Lists.newArrayList(this.recordList), startCharPosition);
            this.recordList.clear();
        }
        return record;
    }

    private static final class Headers {
        final Map<String, Integer> headerMap;
        final List<String> headerNames;

        Headers(Map<String, Integer> headerMap, List<String> headerNames) {
            this.headerMap = headerMap;
            this.headerNames = headerNames;
        }
    }
}

