/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordParser
extends AbstractColumnOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(ParquetRecordParser.class);
    private final ParquetReader<Group> reader;
    private final Map<Integer, PrimitiveType.PrimitiveTypeName> fieldTypeMap = new LinkedHashMap<Integer, PrimitiveType.PrimitiveTypeName>();

    private ParquetRecordParser(ParquetReader<Group> reader, MessageType messageType) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Parquet reader is null");
        this.reader = reader;
        for (int i = 0; i < messageType.getFields().size(); ++i) {
            Type type = (Type)messageType.getFields().get(i);
            this.fieldTypeMap.put(i, type.asPrimitiveType().getPrimitiveTypeName());
        }
    }

    public static ParquetRecordParser parse(URI uri, Configuration conf) throws Exception {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
        return new Builder().withUri(uri).withConf(conf).build();
    }

    public static ParquetRecordParser parse(String path, Configuration conf) throws Exception {
        return ParquetRecordParser.parse(new URI(path), conf);
    }

    @Override
    public Record extractRecord() throws IOException {
        Group group = (Group)this.reader.read();
        if (group == null) {
            log.debug("Group is null while parsing parquet record failed");
            return null;
        }
        String[] values = new String[this.fieldTypeMap.size()];
        block8: for (int i = 0; i < this.fieldTypeMap.size(); ++i) {
            switch (this.fieldTypeMap.get(i)) {
                case INT32: {
                    values[i] = String.valueOf(group.getInteger(i, 0));
                    continue block8;
                }
                case INT64: {
                    values[i] = String.valueOf(group.getLong(i, 0));
                    continue block8;
                }
                case INT96: {
                    values[i] = group.getInt96(i, 0).toString();
                    continue block8;
                }
                case BOOLEAN: {
                    values[i] = String.valueOf(group.getBoolean(i, 0));
                    continue block8;
                }
                case FLOAT: {
                    values[i] = String.valueOf(group.getFloat(i, 0));
                    continue block8;
                }
                case DOUBLE: {
                    values[i] = String.valueOf(group.getDouble(i, 0));
                    continue block8;
                }
                default: {
                    values[i] = group.getString(i, 0);
                }
            }
        }
        return new Record(values);
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.closed = true;
        }
        super.close();
    }

    public static class Builder {
        private URI uri;
        private Configuration conf = new Configuration();

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ParquetRecordParser build() throws Exception {
            Preconditions.checkArgument((this.uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
            ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.uri)).withConf(this.conf).usePageChecksumVerification(false).build();
            try (ParquetFileReader r = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(this.uri), (Configuration)this.conf));){
                ParquetRecordParser parquetRecordParser = new ParquetRecordParser(reader, r.getFooter().getFileMetaData().getSchema());
                return parquetRecordParser;
            }
        }
    }
}

