/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import java.io.IOException;
import java.net.URI;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordParserV2
extends AbstractColumnOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(ParquetRecordParserV2.class);
    private final ParquetReader<Group> reader;
    private ColumnValueGetter[] columnHandlers;

    private ParquetRecordParserV2(ParquetReader<Group> reader, MessageType messageType) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Parquet reader is null");
        this.reader = reader;
        this.initColumnHandlerMap(messageType);
    }

    public static ParquetRecordParserV2 parse(URI uri, Configuration conf) throws Exception {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
        return new Builder().withUri(uri).withConf(conf).build();
    }

    public static ParquetRecordParserV2 parse(String path, Configuration conf) throws Exception {
        return ParquetRecordParserV2.parse(new URI(path), conf);
    }

    @Override
    public Record extractRecord() throws IOException {
        Group group = (Group)this.reader.read();
        if (group == null) {
            log.debug("Group is null while parsing parquet record failed");
            return null;
        }
        int colNum = this.columnHandlers.length;
        String[] values = new String[colNum];
        Stream.iterate(0, i -> i + 1).limit(colNum).forEach(i -> {
            values[i.intValue()] = this.columnHandlers[i].getValue(group, (int)i);
        });
        return new Record(values);
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.closed = true;
        }
        super.close();
    }

    private void initColumnHandlerMap(MessageType messageType) {
        int colNum = messageType.getFields().size();
        this.columnHandlers = new ColumnValueGetter[colNum];
        block8: for (int i = 0; i < colNum; ++i) {
            Type type = (Type)messageType.getFields().get(i);
            switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getInteger(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getInteger(colIdx, 0));
                    continue block8;
                }
                case INT64: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getLong(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getLong(colIdx, 0));
                    continue block8;
                }
                case INT96: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getInt96(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getInt96(colIdx, 0));
                    continue block8;
                }
                case BOOLEAN: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getBoolean(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getBoolean(colIdx, 0));
                    continue block8;
                }
                case FLOAT: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getFloat(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getFloat(colIdx, 0));
                    continue block8;
                }
                case DOUBLE: {
                    if (type.getRepetition() != Type.Repetition.REQUIRED) {
                        this.columnHandlers[i] = (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getDouble(colIdx, 0));
                        continue block8;
                    }
                    this.columnHandlers[i] = (group, colIdx) -> String.valueOf(group.getLong(colIdx, 0));
                    continue block8;
                }
                default: {
                    this.columnHandlers[i] = type.getRepetition() != Type.Repetition.REQUIRED ? (group, colIdx) -> group.getFieldRepetitionCount(colIdx) == 0 ? null : String.valueOf(group.getString(colIdx, 0)) : (group, colIdx) -> String.valueOf(group.getString(colIdx, 0));
                }
            }
        }
    }

    public static class Builder {
        private URI uri;
        private Configuration conf = new Configuration();

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ParquetRecordParserV2 build() throws Exception {
            Preconditions.checkArgument((this.uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
            ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.uri)).withConf(this.conf).usePageChecksumVerification(false).build();
            try (ParquetFileReader r = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(this.uri), (Configuration)this.conf));){
                ParquetRecordParserV2 parquetRecordParserV2 = new ParquetRecordParserV2(reader, r.getFooter().getFileMetaData().getSchema());
                return parquetRecordParserV2;
            }
        }
    }

    static interface ColumnValueGetter {
        public String getValue(Group var1, int var2);
    }
}

