/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.pos;

import java.io.Serializable;

public class Offset
implements Serializable {
    private static final long serialVersionUID = -2440463569223610947L;
    private final int beginIndex;
    private final int endIndex;

    public Offset(int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public int getLength() {
        return this.endIndex - this.beginIndex + 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.beginIndex;
        result = 31 * result + this.endIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Offset other = (Offset)obj;
        if (this.beginIndex != other.beginIndex) {
            return false;
        }
        return this.endIndex == other.endIndex;
    }

    public String toString() {
        return "Offset [" + this.beginIndex + ":" + this.endIndex + "]";
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }
}

