/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.pos;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PosRecordParser
extends AbstractRowOrientedParser {
    private static final int ZERO_BYTE_LENGTH = 0;
    private final String charset;
    private final int length;
    private final List<Offset> offsets;
    private final InputStream stream;

    private PosRecordParser(InputStream stream, String charset, List<Offset> offsets, String columnSplitter, boolean trailDelimiter) {
        this.stream = stream;
        this.charset = charset;
        this.offsets = offsets;
        int len = offsets.get(offsets.size() - 1).getEndIndex() + 1;
        if (trailDelimiter) {
            len += columnSplitter == null ? 0 : columnSplitter.getBytes().length;
        }
        this.length = len;
    }

    public static PosRecordParser parse(File file, String charset, List<Offset> offsets, String columnSplitter, boolean trailDelimiter) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(Files.newInputStream(file.toPath(), new OpenOption[0]), charset, offsets, columnSplitter, trailDelimiter);
    }

    public static PosRecordParser parse(InputStream stream, String charset, List<Offset> offsets, String columnSplitter, boolean trailDelimiter) throws IOException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(stream, charset, offsets, columnSplitter, trailDelimiter);
    }

    public static PosRecordParser parse(Path path, String charset, List<Offset> offsets, String columnSplitter, boolean trailDelimiter) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return PosRecordParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, offsets, columnSplitter, trailDelimiter);
    }

    public static PosRecordParser parse(URL url, String charset, List<Offset> offsets, String columnSplitter, boolean trailDelimiter) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(url.openStream(), charset, offsets, columnSplitter, trailDelimiter);
    }

    @Override
    public Record nextRecord() throws IOException {
        byte[] src = new byte[this.length];
        try {
            int available = this.stream.read(src);
            if (available < 0) {
                return null;
            }
            if (available < this.length) {
                byte[] dest = new byte[available];
                System.arraycopy(src, 0, dest, 0, available);
                src = dest;
            }
            int size = this.offsets.size();
            ArrayList<String> values = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                Offset offset = this.offsets.get(i);
                byte[] dest = new byte[offset.getLength()];
                System.arraycopy(src, offset.getBeginIndex() - 1, dest, 0, dest.length);
                values.add(new String(dest, this.charset));
            }
            return new Record(values, 1L);
        }
        catch (Exception e) {
            return new Record(new String(src, this.charset), new ArrayList<String>(), e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.stream != null) {
            this.stream.close();
            this.closed = true;
        }
        super.close();
    }

    public String getCharset() {
        return this.charset;
    }

    public int getLength() {
        return this.length;
    }

    public List<Offset> getOffsets() {
        return this.offsets;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

