/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.schema;

import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class SchemaFileParser {
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DELIMITER_NAME = "delimiter";
    private static final String DELIMTIER_DEF_REGEX = "(?i)delimiter\\s+(.)+";
    private static final int DELIMITER_NAME_LEN = "delimiter".length() - 1;
    private static final int SERVER_STATUS_NO_BACKSLASH_ESCAPES = 512;
    private final boolean oracleMode;
    private int serverStatus;
    private char instring = '\u0000';
    private boolean mlcomment = false;
    private String delimiter = ";";

    public SchemaFileParser(boolean isOracleMode) {
        this.oracleMode = isOracleMode;
    }

    public List<String> batchReadSql(String filePath, String fileEncoding) throws Exception {
        return this.batchReadSql(new File(filePath), fileEncoding);
    }

    public List<String> batchReadSql(File file, String fileEncoding) throws Exception {
        this.checkFileState(file);
        ArrayList<String> sqls = new ArrayList<String>();
        try (LineIterator iter = FileUtils.lineIterator((File)file, (String)fileEncoding);){
            StringBuilder buffer = new StringBuilder();
            while (iter.hasNext()) {
                String line = iter.nextLine();
                if (StringUtils.isBlank(line)) continue;
                if ((line = line.trim()).matches(DELIMTIER_DEF_REGEX)) {
                    this.delimiter = line.substring(line.indexOf(32)).trim();
                    continue;
                }
                this.addLine(sqls, buffer, line, false);
            }
        }
        return sqls.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void checkFileState(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The input file is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File: \"" + file.getPath() + "\" not found");
        }
        if (file.isHidden()) {
            throw new IllegalArgumentException("File: \"" + file.getPath() + "\" is hidden");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File: \"" + file.getPath() + "\" can't read");
        }
    }

    public List<String> batchReadSql(InputStream inputStream, String fileEncoding) throws Exception {
        return this.batchReadSql(new InputStreamReader(inputStream, fileEncoding));
    }

    public List<String> batchReadSql(Reader reader) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(reader);){
            StringBuilder buffer = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank(line)) continue;
                if ((line = line.trim()).matches(DELIMTIER_DEF_REGEX)) {
                    this.delimiter = line.substring(line.indexOf(32)).trim();
                    continue;
                }
                this.addLine(sqls, buffer, line, false);
            }
        }
        return sqls.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void addLine(List<String> sqls, StringBuilder buffer, String line, boolean truncated) {
        SSC ssc = SSC.NONE;
        char inchar = '\u0000';
        int eof = line.length();
        int delimLength = this.delimiter.length();
        int pos = 0;
        int out = 0;
        boolean needspace = false;
        char[] lines = line.toCharArray();
        lines = Arrays.copyOf(lines, eof + 1);
        lines[eof] = '\u0000';
        boolean isOracleMode = this.isOracleMode();
        out = 0;
        for (pos = 0; pos < eof; ++pos) {
            inchar = lines[pos];
            if (!(this.mlcomment || inchar != '\\' || this.instring != '\u0000' && isOracleMode)) {
                if ((inchar = lines[++pos]) == '\u0000') break;
                if (this.instring == '\u0000' && inchar != 'N') continue;
                lines[out++] = 92;
                if (inchar == '`' && this.instring == inchar) {
                    --pos;
                    continue;
                }
                lines[out++] = inchar;
                continue;
            }
            if (!this.mlcomment && (this.instring != '\u0000' && isOracleMode && pos + 1 == eof || this.instring == '\u0000') && ssc != SSC.HINT && this.isPrefix(lines, pos, this.delimiter)) {
                pos += delimLength;
                if (out != 0) {
                    buffer.append(lines, 0, out);
                    out = 0;
                }
                if (this.isDelimiterCommand(lines, pos)) {
                    return;
                }
                sqls.add(buffer.toString());
                --pos;
                if (isOracleMode) {
                    this.instring = '\u0000';
                }
                buffer.setLength(0);
                this.delimiter = DEFAULT_DELIMITER;
                continue;
            }
            if (!this.mlcomment && this.instring == '\u0000' && (inchar == '#' && !isOracleMode || inchar == '-' && lines[pos + 1] == '-' && (Character.isWhitespace(lines[pos + 2]) || lines[pos + 2] == '\u0000'))) {
                if (out == 0) break;
                buffer.append(lines, 0, out);
                out = 0;
                break;
            }
            if (this.instring == '\u0000' && inchar == '/' && lines[pos + 1] == '*' && lines[pos + 2] != '!' && lines[pos + 2] != '+' && ssc != SSC.HINT) {
                ++pos;
                this.mlcomment = true;
                if (out == 0) continue;
                buffer.append(lines, 0, out);
                out = 0;
                continue;
            }
            if (this.mlcomment && ssc.getValue() == 0 && inchar == '*' && lines[pos + 1] == '/') {
                ++pos;
                this.mlcomment = false;
                if (out != 0) {
                    buffer.append(lines, 0, out);
                    out = 0;
                }
                needspace = true;
                continue;
            }
            if (this.instring == '\u0000' && inchar == '/' && lines[pos + 1] == '*') {
                if (lines[pos + 2] == '!') {
                    ssc = SSC.CONDITIONAL;
                } else if (lines[pos + 2] == '+') {
                    ssc = SSC.HINT;
                }
            } else if (this.instring == '\u0000' && ssc.getValue() != 0 && inchar == '*' && lines[pos + 1] == '/') {
                ssc = SSC.NONE;
                lines[out++] = lines[pos++];
                inchar = lines[pos];
            }
            if (inchar == this.instring) {
                this.instring = '\u0000';
            } else if (!(this.mlcomment || this.instring != '\u0000' || ssc == SSC.HINT || inchar != '\'' && inchar != '\"' && inchar != '`')) {
                this.instring = inchar;
            }
            if (this.mlcomment) continue;
            if (needspace && !Character.isWhitespace(inchar)) {
                lines[out++] = 32;
            }
            needspace = false;
            lines[out++] = inchar;
        }
        if (out != 0 || buffer.length() != 0) {
            int length = out;
            if (!this.isDelimiterCommand(lines, length) || this.instring != '\u0000' || this.mlcomment) {
                lines[out++] = 10;
                ++length;
            }
            if (!this.mlcomment) {
                buffer.append(lines, 0, length);
            }
        }
        if (!this.mlcomment && this.instring == '\u0000' && line.endsWith(this.delimiter) && !this.isDelimiterCommand(lines, pos)) {
            sqls.add(buffer.toString());
            buffer.setLength(0);
            this.delimiter = DEFAULT_DELIMITER;
        }
    }

    private boolean isDelimiterCommand(char[] line, int length) {
        String delimiter = new String(line).toLowerCase(Locale.getDefault());
        return length >= DELIMITER_NAME_LEN && (DELIMITER_NAME.equals(delimiter) || delimiter.startsWith(DELIMITER_NAME));
    }

    private boolean isPrefix(char[] line, int pos, String delim) {
        return new String(line, pos, line.length - pos).startsWith(delim);
    }

    public boolean isOracleMode() {
        return this.oracleMode;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public static enum SSC {
        NONE(0),
        HINT(1),
        CONDITIONAL(2);

        private final int value;

        private SSC(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

