/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.oceanbase.tools.loaddump.parser.record.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class Payload {
    private final int batchSize;
    private AtomicLong byteSize;
    private List<Record> recordList;

    public Payload(int batchSize) {
        this.batchSize = batchSize;
        this.byteSize = new AtomicLong(0L);
        this.recordList = new ArrayList<Record>();
    }

    public void addByteSize(long byteSize) {
        this.byteSize.getAndAdd(byteSize);
    }

    public void addRecord(Record record) {
        this.recordList.add(record);
    }

    public int getRecordCount() {
        return this.recordList.size();
    }

    public long getBatchByteSize() {
        return this.byteSize.get();
    }

    public boolean isShouldCommit() {
        int recordCount = this.getRecordCount();
        return recordCount > 0 && recordCount % this.batchSize == 0;
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }
}

