/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.resource.AbstractResourceFinder;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.local.LocalResource;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceFinder
extends AbstractResourceFinder<Resource> {
    private static final Logger log = LoggerFactory.getLogger(LocalResourceFinder.class);

    public LocalResourceFinder(BaseParameter parameter) {
        super(parameter);
    }

    @Override
    public List<Resource> listSchemaResources() {
        File file = new File(this.filePath);
        if (file.isFile() && file.canRead()) {
            long totalSize = com.oceanbase.tools.loaddump.utils.FileUtils.getSize(file);
            if (totalSize < 1L) {
                log.info("File: \"{}\" is empty, ignore it", (Object)file.getAbsolutePath());
                return Lists.newArrayList();
            }
            log.info("Binding table: \"{}\" to the file: \"{}\" finished", (Object)file.getName(), (Object)file.getAbsolutePath());
            return Lists.newArrayList((Object[])new Resource[]{new LocalResource(ObjectType.FILE.getName(), file.getName(), file.getAbsolutePath(), totalSize)});
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        DataFormat dataFormat = this.parameter.getDataFormat();
        String[] extensions = new String[]{dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileExtension : DataFormat.DDL.getDefaultExtension()};
        List files = FileUtils.listFiles((File)file, (String[])extensions, (boolean)true).stream().filter(f -> f.isFile() && f.canRead()).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)ObjectUtils.isNotEmpty(files), (String)"Schema files(\".%s\") are not found. Path: \"%s\".", (Object)extensions[0], (Object)this.filePath);
        if (this.parameter.isIncludeDdl()) {
            files = files.stream().filter(f -> f.getName().endsWith("-schema.sql")).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)ObjectUtils.isNotEmpty(files), (String)"Schema files(\"-schema.sql\") are not found. Path: \"%s\".", (Object)this.filePath);
        }
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        ArrayList<Resource> resources = new ArrayList<Resource>(files.size());
        for (File tempFile : files) {
            String fileName = tempFile.getName();
            String parentPath = tempFile.getParent();
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            if (this.parameter.getDataFormat() == DataFormat.MIX && objectType == ObjectType.FILE) {
                resources.add(new LocalResource(objectTypeName, fileName, tempFile.getAbsolutePath(), com.oceanbase.tools.loaddump.utils.FileUtils.getSize(tempFile)));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType)) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            List<String> whiteSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)whiteListMap.get((Object)objectType));
            List<String> blackSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)blackListMap.get((Object)objectType));
            if (!CollectionUtils.isEmpty(whiteSet) && !whiteSet.contains(objectName) || blackSet.contains(objectName)) continue;
            resources.add(new LocalResource(objectTypeName, objectName, tempFile.getAbsolutePath(), com.oceanbase.tools.loaddump.utils.FileUtils.getSize(tempFile)));
        }
        log.info("Find {} resources in local path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.filePath, stopwatch});
        return resources;
    }

    @Override
    public List<Resource> listRecordResources() {
        String[] stringArray;
        boolean isNotUseRegularExpr;
        File file = new File(this.filePath);
        if (file.isFile() && file.canRead()) {
            Preconditions.checkArgument((this.tableNames.size() == 1 ? 1 : 0) != 0, (String)"Specified table count=(%s) is unexpected. As -f/--file is a file.", (int)this.tableNames.size());
            long totalSize = com.oceanbase.tools.loaddump.utils.FileUtils.getSize(file);
            if (totalSize < 1L) {
                log.info("File: \"{}\" is empty, ignore it", (Object)file.getAbsolutePath());
                return Lists.newArrayList();
            }
            log.info("Binding table: \"{}\" to the file: \"{}\" finished", this.tableNames.get(0), (Object)file.getAbsolutePath());
            return Lists.newArrayList((Object[])new Resource[]{new LocalResource(ObjectType.TABLE.getName(), (String)this.tableNames.get(0), file.getAbsolutePath(), totalSize)});
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean bl = isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        if (isNotUseRegularExpr) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.fileExtension;
        } else {
            stringArray = null;
        }
        String[] extensions = stringArray;
        List files = FileUtils.listFiles((File)file, (String[])extensions, (boolean)true).stream().filter(f -> f.isFile() && f.canRead()).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)ObjectUtils.isNotEmpty(files), (String)"Data files(\"%s\") are not found. Path: \"%s\".", (Object)this.fileSuffix, (Object)this.filePath);
        ArrayList<Resource> resources = new ArrayList<Resource>(files.size());
        for (File temp : files) {
            String tableName;
            long totalSize = com.oceanbase.tools.loaddump.utils.FileUtils.getSize(temp);
            if (totalSize < 1L) {
                log.info("File: \"{}\" is empty, ignore it", (Object)temp.getPath());
                continue;
            }
            if (isNotUseRegularExpr && temp.getName().endsWith("-schema.sql")) {
                log.info("File: \"{}\" is unmatched with file suffix[{}], ignore it", (Object)temp.getPath(), (Object)this.fileSuffix);
                continue;
            }
            String string = tableName = isNotUseRegularExpr ? this.binding0(this.tableNames, temp) : this.binding1(this.tableNames, temp);
            if (tableName == null) {
                log.info("File: \"{}\" is not contained, ignore it", (Object)temp.getAbsolutePath());
                continue;
            }
            resources.add(new LocalResource(ObjectType.TABLE.getName(), tableName, temp.getAbsolutePath(), totalSize));
            log.info("Binding table: \"{}\" to the file: \"{}\" finished", (Object)tableName, (Object)temp.getAbsolutePath());
        }
        log.info("Find {} resources in local path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.filePath, stopwatch});
        return resources;
    }
}

